/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.BinaryType;
import org.apache.paimon.types.BooleanType;
import org.apache.paimon.types.CharType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeDefaultVisitor;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.DateType;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.DoubleType;
import org.apache.paimon.types.FloatType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.SmallIntType;
import org.apache.paimon.types.TimeType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.types.VarBinaryType;
import org.apache.paimon.types.VarCharType;

public class HiveTypeUtils {
    public static TypeInfo toTypeInfo(DataType logicalType) {
        return logicalType.accept(PaimonToHiveTypeVisitor.INSTANCE);
    }

    public static DataType toPaimonType(String type) {
        TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)type);
        return HiveTypeUtils.toPaimonType(typeInfo);
    }

    public static DataType toPaimonType(TypeInfo typeInfo) {
        return HiveToPaimonTypeVisitor.visit(typeInfo);
    }

    private static class HiveToPaimonTypeVisitor {
        private HiveToPaimonTypeVisitor() {
        }

        static DataType visit(TypeInfo type) {
            return HiveToPaimonTypeVisitor.visit(type, new HiveToPaimonTypeVisitor());
        }

        static DataType visit(TypeInfo type, HiveToPaimonTypeVisitor visitor) {
            if (type instanceof StructTypeInfo) {
                StructTypeInfo structTypeInfo = (StructTypeInfo)type;
                ArrayList fieldNames = structTypeInfo.getAllStructFieldNames();
                ArrayList typeInfos = structTypeInfo.getAllStructFieldTypeInfos();
                RowType.Builder builder = RowType.builder();
                for (int i = 0; i < fieldNames.size(); ++i) {
                    builder.field((String)fieldNames.get(i), HiveToPaimonTypeVisitor.visit((TypeInfo)typeInfos.get(i), visitor));
                }
                return builder.build();
            }
            if (type instanceof MapTypeInfo) {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)type;
                return DataTypes.MAP(HiveToPaimonTypeVisitor.visit(mapTypeInfo.getMapKeyTypeInfo(), visitor), HiveToPaimonTypeVisitor.visit(mapTypeInfo.getMapValueTypeInfo(), visitor));
            }
            if (type instanceof ListTypeInfo) {
                ListTypeInfo listTypeInfo = (ListTypeInfo)type;
                return DataTypes.ARRAY(HiveToPaimonTypeVisitor.visit(listTypeInfo.getListElementTypeInfo(), visitor));
            }
            return visitor.atomic(type);
        }

        public DataType atomic(TypeInfo atomic) {
            if (TypeInfoFactory.booleanTypeInfo.equals((Object)atomic)) {
                return DataTypes.BOOLEAN();
            }
            if (TypeInfoFactory.byteTypeInfo.equals((Object)atomic)) {
                return DataTypes.TINYINT();
            }
            if (TypeInfoFactory.shortTypeInfo.equals((Object)atomic)) {
                return DataTypes.SMALLINT();
            }
            if (TypeInfoFactory.intTypeInfo.equals((Object)atomic)) {
                return DataTypes.INT();
            }
            if (TypeInfoFactory.longTypeInfo.equals((Object)atomic)) {
                return DataTypes.BIGINT();
            }
            if (TypeInfoFactory.floatTypeInfo.equals((Object)atomic)) {
                return DataTypes.FLOAT();
            }
            if (TypeInfoFactory.doubleTypeInfo.equals((Object)atomic)) {
                return DataTypes.DOUBLE();
            }
            if (atomic instanceof DecimalTypeInfo) {
                DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)atomic;
                return DataTypes.DECIMAL(decimalTypeInfo.getPrecision(), decimalTypeInfo.getScale());
            }
            if (atomic instanceof CharTypeInfo) {
                return DataTypes.CHAR(((CharTypeInfo)atomic).getLength());
            }
            if (atomic instanceof VarcharTypeInfo) {
                return DataTypes.VARCHAR(((VarcharTypeInfo)atomic).getLength());
            }
            if (TypeInfoFactory.stringTypeInfo.equals((Object)atomic)) {
                return DataTypes.VARCHAR(Integer.MAX_VALUE);
            }
            if (TypeInfoFactory.binaryTypeInfo.equals((Object)atomic)) {
                return DataTypes.VARBINARY(Integer.MAX_VALUE);
            }
            if (TypeInfoFactory.dateTypeInfo.equals((Object)atomic)) {
                return DataTypes.DATE();
            }
            if (TypeInfoFactory.timestampTypeInfo.equals((Object)atomic)) {
                return DataTypes.TIMESTAMP_MILLIS();
            }
            throw new UnsupportedOperationException("Not a supported type: " + atomic.getTypeName());
        }
    }

    private static class PaimonToHiveTypeVisitor
    extends DataTypeDefaultVisitor<TypeInfo> {
        private static final PaimonToHiveTypeVisitor INSTANCE = new PaimonToHiveTypeVisitor();

        private PaimonToHiveTypeVisitor() {
        }

        @Override
        public TypeInfo visit(BooleanType booleanType) {
            return TypeInfoFactory.booleanTypeInfo;
        }

        @Override
        public TypeInfo visit(TinyIntType tinyIntType) {
            return TypeInfoFactory.byteTypeInfo;
        }

        @Override
        public TypeInfo visit(SmallIntType smallIntType) {
            return TypeInfoFactory.shortTypeInfo;
        }

        @Override
        public TypeInfo visit(IntType intType) {
            return TypeInfoFactory.intTypeInfo;
        }

        @Override
        public TypeInfo visit(BigIntType bigIntType) {
            return TypeInfoFactory.longTypeInfo;
        }

        @Override
        public TypeInfo visit(FloatType floatType) {
            return TypeInfoFactory.floatTypeInfo;
        }

        @Override
        public TypeInfo visit(DoubleType doubleType) {
            return TypeInfoFactory.doubleTypeInfo;
        }

        @Override
        public TypeInfo visit(DecimalType decimalType) {
            return TypeInfoFactory.getDecimalTypeInfo((int)decimalType.getPrecision(), (int)decimalType.getScale());
        }

        @Override
        public TypeInfo visit(CharType charType) {
            if (charType.getLength() > 255) {
                return TypeInfoFactory.stringTypeInfo;
            }
            return TypeInfoFactory.getCharTypeInfo((int)charType.getLength());
        }

        @Override
        public TypeInfo visit(VarCharType varCharType) {
            if (varCharType.getLength() > 65535) {
                return TypeInfoFactory.stringTypeInfo;
            }
            return TypeInfoFactory.getVarcharTypeInfo((int)varCharType.getLength());
        }

        @Override
        public TypeInfo visit(BinaryType binaryType) {
            return TypeInfoFactory.binaryTypeInfo;
        }

        @Override
        public TypeInfo visit(VarBinaryType varBinaryType) {
            return TypeInfoFactory.binaryTypeInfo;
        }

        @Override
        public TypeInfo visit(DateType dateType) {
            return TypeInfoFactory.dateTypeInfo;
        }

        @Override
        public TypeInfo visit(TimeType timeType) {
            return TypeInfoFactory.stringTypeInfo;
        }

        @Override
        public TypeInfo visit(TimestampType timestampType) {
            return TypeInfoFactory.timestampTypeInfo;
        }

        @Override
        public TypeInfo visit(LocalZonedTimestampType localZonedTimestampType) {
            return TypeInfoFactory.timestampTypeInfo;
        }

        @Override
        public TypeInfo visit(ArrayType arrayType) {
            DataType elementType = arrayType.getElementType();
            return TypeInfoFactory.getListTypeInfo((TypeInfo)elementType.accept(this));
        }

        @Override
        public TypeInfo visit(MultisetType multisetType) {
            return TypeInfoFactory.getMapTypeInfo((TypeInfo)multisetType.getElementType().accept(this), (TypeInfo)TypeInfoFactory.intTypeInfo);
        }

        @Override
        public TypeInfo visit(MapType mapType) {
            return TypeInfoFactory.getMapTypeInfo((TypeInfo)mapType.getKeyType().accept(this), (TypeInfo)mapType.getValueType().accept(this));
        }

        @Override
        public TypeInfo visit(RowType rowType) {
            List fieldNames = rowType.getFields().stream().map(DataField::name).collect(Collectors.toList());
            List typeInfos = rowType.getFields().stream().map(DataField::type).map(type -> type.accept(this)).collect(Collectors.toList());
            return TypeInfoFactory.getStructTypeInfo(fieldNames, typeInfos);
        }

        @Override
        protected TypeInfo defaultMethod(DataType dataType) {
            throw new UnsupportedOperationException("Unsupported type: " + dataType);
        }
    }
}

