/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.index;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.utils.IntFileUtils;
import org.apache.paimon.utils.IntIterator;
import org.apache.paimon.utils.PathFactory;

public class HashIndexFile {
    public static final String HASH_INDEX = "HASH";
    private final FileIO fileIO;
    private final PathFactory pathFactory;

    public HashIndexFile(FileIO fileIO, PathFactory pathFactory) {
        this.fileIO = fileIO;
        this.pathFactory = pathFactory;
    }

    public long fileSize(String fileName) {
        try {
            return this.fileIO.getFileSize(this.pathFactory.toPath(fileName));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public IntIterator read(String fileName) throws IOException {
        return IntFileUtils.readInts(this.fileIO, this.pathFactory.toPath(fileName));
    }

    public String write(IntIterator input) throws IOException {
        Path path = this.pathFactory.newPath();
        IntFileUtils.writeInts(this.fileIO, path, input);
        return path.getName();
    }

    public void delete(String fileName) {
        this.fileIO.deleteQuietly(this.pathFactory.toPath(fileName));
    }

    public boolean exists(String fileName) {
        try {
            return this.fileIO.exists(this.pathFactory.toPath(fileName));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

