/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.paimon.PartitionSettedRow;
import org.apache.paimon.casting.CastFieldGetter;
import org.apache.paimon.casting.CastedRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.PartitionInfo;
import org.apache.paimon.data.columnar.ColumnarRowIterator;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.utils.FileUtils;
import org.apache.paimon.utils.ProjectedRow;

public class RowDataFileRecordReader
implements RecordReader<InternalRow> {
    private final RecordReader<InternalRow> reader;
    @Nullable
    private final int[] indexMapping;
    @Nullable
    private final PartitionInfo partitionInfo;
    @Nullable
    private final CastFieldGetter[] castMapping;

    public RowDataFileRecordReader(FileIO fileIO, Path path, FormatReaderFactory readerFactory, @Nullable int[] indexMapping, @Nullable CastFieldGetter[] castMapping, @Nullable PartitionInfo partitionInfo) throws IOException {
        this.reader = FileUtils.createFormatReader(fileIO, readerFactory, path);
        this.indexMapping = indexMapping;
        this.partitionInfo = partitionInfo;
        this.castMapping = castMapping;
    }

    @Override
    @Nullable
    public RecordReader.RecordIterator<InternalRow> readBatch() throws IOException {
        RecordReader.RecordIterator<InternalRow> iterator = this.reader.readBatch();
        if (iterator == null) {
            return null;
        }
        if (iterator instanceof ColumnarRowIterator) {
            iterator = ((ColumnarRowIterator)iterator).mapping(this.partitionInfo, this.indexMapping);
        } else {
            if (this.partitionInfo != null) {
                PartitionSettedRow partitionSettedRow = PartitionSettedRow.from(this.partitionInfo);
                iterator = iterator.transform(partitionSettedRow::replaceRow);
            }
            if (this.indexMapping != null) {
                ProjectedRow projectedRow = ProjectedRow.from(this.indexMapping);
                iterator = iterator.transform(projectedRow::replaceRow);
            }
        }
        if (this.castMapping != null) {
            CastedRow castedRow = CastedRow.from(this.castMapping);
            iterator = iterator.transform(castedRow::replaceRow);
        }
        return iterator;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

