/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.compact.CompactResult;
import org.apache.paimon.compact.CompactTask;
import org.apache.paimon.compact.CompactUnit;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.mergetree.SortedRun;
import org.apache.paimon.mergetree.compact.CompactRewriter;
import org.apache.paimon.mergetree.compact.IntervalPartition;
import org.apache.paimon.operation.metrics.CompactionMetrics;

public class MergeTreeCompactTask
extends CompactTask {
    private final long minFileSize;
    private final CompactRewriter rewriter;
    private final int outputLevel;
    private final List<List<SortedRun>> partitioned;
    private final boolean dropDelete;
    private int upgradeFilesNum;

    public MergeTreeCompactTask(Comparator<InternalRow> keyComparator, long minFileSize, CompactRewriter rewriter, CompactUnit unit, boolean dropDelete, @Nullable CompactionMetrics metrics) {
        super(metrics);
        this.minFileSize = minFileSize;
        this.rewriter = rewriter;
        this.outputLevel = unit.outputLevel();
        this.partitioned = new IntervalPartition(unit.files(), keyComparator).partition();
        this.dropDelete = dropDelete;
        this.upgradeFilesNum = 0;
    }

    @Override
    protected CompactResult doCompact() throws Exception {
        ArrayList<List<SortedRun>> candidate = new ArrayList<List<SortedRun>>();
        CompactResult result = new CompactResult();
        for (List<SortedRun> section : this.partitioned) {
            if (section.size() > 1) {
                candidate.add(section);
                continue;
            }
            SortedRun run = section.get(0);
            for (DataFileMeta file : run.files()) {
                if (file.fileSize() < this.minFileSize) {
                    candidate.add(Collections.singletonList(SortedRun.fromSingle(file)));
                    continue;
                }
                this.rewrite(candidate, result);
                this.upgrade(file, result);
            }
        }
        this.rewrite(candidate, result);
        return result;
    }

    @Override
    protected String logMetric(long startMillis, List<DataFileMeta> compactBefore, List<DataFileMeta> compactAfter) {
        return String.format("%s, upgrade file num = %d", super.logMetric(startMillis, compactBefore, compactAfter), this.upgradeFilesNum);
    }

    private void upgrade(DataFileMeta file, CompactResult toUpdate) throws Exception {
        if (file.level() != this.outputLevel) {
            CompactResult upgradeResult = this.rewriter.upgrade(this.outputLevel, file);
            toUpdate.merge(upgradeResult);
            ++this.upgradeFilesNum;
        }
    }

    private void rewrite(List<List<SortedRun>> candidate, CompactResult toUpdate) throws Exception {
        if (candidate.isEmpty()) {
            return;
        }
        if (candidate.size() == 1) {
            List<SortedRun> section = candidate.get(0);
            if (section.size() == 0) {
                return;
            }
            if (section.size() == 1) {
                for (DataFileMeta file : section.get(0).files()) {
                    this.upgrade(file, toUpdate);
                }
                candidate.clear();
                return;
            }
        }
        CompactResult rewriteResult = this.rewriter.rewrite(this.outputLevel, this.dropDelete, candidate);
        toUpdate.merge(rewriteResult);
        candidate.clear();
    }
}

