/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.util.Comparator;
import java.util.List;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.mergetree.compact.MergeFunctionWrapper;
import org.apache.paimon.mergetree.compact.SortMergeReaderWithLoserTree;
import org.apache.paimon.mergetree.compact.SortMergeReaderWithMinHeap;
import org.apache.paimon.reader.RecordReader;

public interface SortMergeReader<T>
extends RecordReader<T> {
    public static <T> SortMergeReader<T> createSortMergeReader(List<RecordReader<KeyValue>> readers, Comparator<InternalRow> userKeyComparator, MergeFunctionWrapper<T> mergeFunctionWrapper, CoreOptions.SortEngine sortEngine) {
        switch (sortEngine) {
            case MIN_HEAP: {
                return new SortMergeReaderWithMinHeap<T>(readers, userKeyComparator, mergeFunctionWrapper);
            }
            case LOSER_TREE: {
                return new SortMergeReaderWithLoserTree<T>(readers, userKeyComparator, mergeFunctionWrapper);
            }
        }
        throw new UnsupportedOperationException("Unsupported sort engine: " + sortEngine);
    }
}

