/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact.aggregate;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.paimon.mergetree.compact.aggregate.FieldBoolAndAgg;
import org.apache.paimon.mergetree.compact.aggregate.FieldBoolOrAgg;
import org.apache.paimon.mergetree.compact.aggregate.FieldFirstNotNullValueAgg;
import org.apache.paimon.mergetree.compact.aggregate.FieldFirstValueAgg;
import org.apache.paimon.mergetree.compact.aggregate.FieldIgnoreRetractAgg;
import org.apache.paimon.mergetree.compact.aggregate.FieldLastNonNullValueAgg;
import org.apache.paimon.mergetree.compact.aggregate.FieldLastValueAgg;
import org.apache.paimon.mergetree.compact.aggregate.FieldListaggAgg;
import org.apache.paimon.mergetree.compact.aggregate.FieldMaxAgg;
import org.apache.paimon.mergetree.compact.aggregate.FieldMinAgg;
import org.apache.paimon.mergetree.compact.aggregate.FieldPrimaryKeyAgg;
import org.apache.paimon.mergetree.compact.aggregate.FieldSumAgg;
import org.apache.paimon.types.DataType;

public abstract class FieldAggregator
implements Serializable {
    protected DataType fieldType;

    public FieldAggregator(DataType dataType) {
        this.fieldType = dataType;
    }

    public static FieldAggregator createFieldAggregator(DataType fieldType, @Nullable String strAgg, boolean ignoreRetract, boolean isPrimaryKey) {
        FieldAggregator fieldAggregator;
        if (isPrimaryKey) {
            fieldAggregator = new FieldPrimaryKeyAgg(fieldType);
        } else if (strAgg == null) {
            fieldAggregator = new FieldLastNonNullValueAgg(fieldType);
        } else {
            switch (strAgg) {
                case "sum": {
                    fieldAggregator = new FieldSumAgg(fieldType);
                    break;
                }
                case "max": {
                    fieldAggregator = new FieldMaxAgg(fieldType);
                    break;
                }
                case "min": {
                    fieldAggregator = new FieldMinAgg(fieldType);
                    break;
                }
                case "last_non_null_value": {
                    fieldAggregator = new FieldLastNonNullValueAgg(fieldType);
                    break;
                }
                case "last_value": {
                    fieldAggregator = new FieldLastValueAgg(fieldType);
                    break;
                }
                case "listagg": {
                    fieldAggregator = new FieldListaggAgg(fieldType);
                    break;
                }
                case "bool_or": {
                    fieldAggregator = new FieldBoolOrAgg(fieldType);
                    break;
                }
                case "bool_and": {
                    fieldAggregator = new FieldBoolAndAgg(fieldType);
                    break;
                }
                case "first_value": {
                    fieldAggregator = new FieldFirstValueAgg(fieldType);
                    break;
                }
                case "first_not_null_value": {
                    fieldAggregator = new FieldFirstNotNullValueAgg(fieldType);
                    break;
                }
                default: {
                    throw new RuntimeException(String.format("Use unsupported aggregation: %s or spell aggregate function incorrectly!", strAgg));
                }
            }
        }
        if (ignoreRetract) {
            fieldAggregator = new FieldIgnoreRetractAgg(fieldAggregator);
        }
        return fieldAggregator;
    }

    abstract String name();

    public abstract Object agg(Object var1, Object var2);

    public void reset() {
    }

    public Object retract(Object accumulator, Object retractField) {
        throw new UnsupportedOperationException(String.format("Aggregate function '%s' does not support retraction, If you allow this function to ignore retraction messages, you can configure 'fields.${field_name}.ignore-retract'='true'.", this.name()));
    }
}

