/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.util.List;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.operation.AbstractFileStoreScan;
import org.apache.paimon.operation.ScanBucketFilter;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.stats.FieldStatsConverters;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.SnapshotManager;

public class AppendOnlyFileStoreScan
extends AbstractFileStoreScan {
    private final FieldStatsConverters fieldStatsConverters;
    private Predicate filter;

    public AppendOnlyFileStoreScan(RowType partitionType, ScanBucketFilter bucketFilter, SnapshotManager snapshotManager, SchemaManager schemaManager, long schemaId, ManifestFile.Factory manifestFileFactory, ManifestList.Factory manifestListFactory, int numOfBuckets, boolean checkNumOfBuckets, Integer scanManifestParallelism) {
        super(partitionType, bucketFilter, snapshotManager, schemaManager, manifestFileFactory, manifestListFactory, numOfBuckets, checkNumOfBuckets, scanManifestParallelism);
        this.fieldStatsConverters = new FieldStatsConverters(sid -> this.scanTableSchema((long)sid).fields(), schemaId);
    }

    public AppendOnlyFileStoreScan withFilter(Predicate predicate) {
        this.filter = predicate;
        this.bucketKeyFilter.pushdown(predicate);
        return this;
    }

    @Override
    protected boolean filterByStats(ManifestEntry entry) {
        return this.filter == null || this.filter.test(entry.file().rowCount(), entry.file().valueStats().fields(this.fieldStatsConverters.getOrCreate(entry.file().schemaId()), entry.file().rowCount()));
    }

    @Override
    protected boolean filterWholeBucketByStats(List<ManifestEntry> entries) {
        return true;
    }
}

