/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.paimon.append.AppendOnlyCompactManager;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.table.source.SplitGenerator;
import org.apache.paimon.utils.BinPacking;

public class AppendOnlySplitGenerator
implements SplitGenerator {
    private final long targetSplitSize;
    private final long openFileCost;
    private final BucketMode bucketMode;

    public AppendOnlySplitGenerator(long targetSplitSize, long openFileCost, BucketMode bucketMode) {
        this.targetSplitSize = targetSplitSize;
        this.openFileCost = openFileCost;
        this.bucketMode = bucketMode;
    }

    @Override
    public List<List<DataFileMeta>> splitForBatch(List<DataFileMeta> input) {
        ArrayList<DataFileMeta> files = new ArrayList<DataFileMeta>(input);
        files.sort(AppendOnlyCompactManager.fileComparator(this.bucketMode == BucketMode.UNAWARE));
        Function<DataFileMeta, Long> weightFunc = file -> Math.max(file.fileSize(), this.openFileCost);
        return BinPacking.packForOrdered(files, weightFunc, this.targetSplitSize);
    }

    @Override
    public List<List<DataFileMeta>> splitForStreaming(List<DataFileMeta> files) {
        if (this.bucketMode == BucketMode.UNAWARE) {
            return this.splitForBatch(files);
        }
        return Collections.singletonList(files);
    }
}

