/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.LazyGenericRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ReadOnceTableScan;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.IteratorRecordReader;
import org.apache.paimon.utils.ProjectedRow;
import org.apache.paimon.utils.RowDataToObjectArrayConverter;
import org.apache.paimon.utils.SerializationUtils;

public class PartitionsTable
implements ReadonlyTable {
    private static final long serialVersionUID = 1L;
    public static final String PARTITIONS = "partitions";
    public static final RowType TABLE_TYPE = new RowType(Arrays.asList(new DataField(0, "partition", SerializationUtils.newStringType(true)), new DataField(1, "record_count", new BigIntType(false)), new DataField(2, "file_size_in_bytes", new BigIntType(false))));
    private final FileStoreTable storeTable;

    public PartitionsTable(FileStoreTable storeTable) {
        this.storeTable = storeTable;
    }

    @Override
    public String name() {
        return this.storeTable.name() + "$" + PARTITIONS;
    }

    @Override
    public RowType rowType() {
        return TABLE_TYPE;
    }

    @Override
    public List<String> primaryKeys() {
        return Collections.singletonList("partition");
    }

    @Override
    public InnerTableScan newScan() {
        return new PartitionsScan(this.storeTable);
    }

    @Override
    public InnerTableRead newRead() {
        return new PartitionsRead();
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new PartitionsTable((FileStoreTable)this.storeTable.copy((Map)dynamicOptions));
    }

    public static Iterator<InternalRow> groupAndSum(Iterator<InternalRow> rows) {
        return new GroupedIterator(rows);
    }

    static class Partition {
        private final BinaryString partition;
        private long recordCount;
        private long fileSizeInBytes;

        Partition(BinaryString partition, long recordCount, long fileSizeInBytes) {
            this.partition = partition;
            this.recordCount = recordCount;
            this.fileSizeInBytes = fileSizeInBytes;
        }

        public long recordCount() {
            return this.recordCount;
        }

        public long fileSize() {
            return this.fileSizeInBytes;
        }
    }

    static class GroupedIterator
    implements Iterator<InternalRow> {
        private final Iterator<InternalRow> rows;
        private final Map<BinaryString, Partition> groupedData;
        private Iterator<Partition> resultIterator;

        public GroupedIterator(Iterator<InternalRow> rows) {
            this.rows = rows;
            this.groupedData = new HashMap<BinaryString, Partition>();
            this.groupAndSum();
        }

        private void groupAndSum() {
            while (this.rows.hasNext()) {
                Partition rowData;
                InternalRow row = this.rows.next();
                BinaryString partitionId = row.getString(0);
                long recordCount = row.getLong(1);
                long fileSizeInBytes = row.getLong(2);
                Partition partition = rowData = this.groupedData.computeIfAbsent(partitionId, key -> new Partition(partitionId, 0L, 0L));
                partition.recordCount = partition.recordCount + recordCount;
                partition = rowData;
                partition.fileSizeInBytes = partition.fileSizeInBytes + fileSizeInBytes;
            }
            this.resultIterator = this.groupedData.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.resultIterator.hasNext();
        }

        @Override
        public InternalRow next() {
            if (this.hasNext()) {
                Partition partition = this.resultIterator.next();
                return GenericRow.of(partition.partition, partition.recordCount, partition.fileSizeInBytes);
            }
            throw new NoSuchElementException("No more elements in the iterator.");
        }
    }

    private static class PartitionsRead
    implements InnerTableRead {
        private int[][] projection;

        private PartitionsRead() {
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public InnerTableRead withProjection(int[][] projection) {
            this.projection = projection;
            return this;
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) throws IOException {
            if (!(split instanceof PartitionsSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            PartitionsSplit filesSplit = (PartitionsSplit)split;
            FileStoreTable table = filesSplit.storeTable;
            TableScan.Plan plan = filesSplit.plan();
            if (plan.splits().isEmpty()) {
                return new IteratorRecordReader<InternalRow>(Collections.emptyIterator());
            }
            ArrayList iteratorList = new ArrayList();
            RowDataToObjectArrayConverter partitionConverter = new RowDataToObjectArrayConverter(table.schema().logicalPartitionType());
            for (Split dataSplit : plan.splits()) {
                iteratorList.add(Iterators.transform(((DataSplit)dataSplit).dataFiles().iterator(), file -> this.toRow((DataSplit)dataSplit, partitionConverter, (DataFileMeta)file)));
            }
            Iterator<InternalRow> rows = Iterators.concat(iteratorList.iterator());
            Iterator<InternalRow> resultRows = PartitionsTable.groupAndSum(rows);
            if (this.projection != null) {
                resultRows = Iterators.transform(resultRows, row -> ProjectedRow.from(this.projection).replaceRow((InternalRow)row));
            }
            return new IteratorRecordReader<InternalRow>(resultRows);
        }

        private LazyGenericRow toRow(DataSplit dataSplit, RowDataToObjectArrayConverter partitionConverter, DataFileMeta dataFileMeta) {
            BinaryString partitionId = dataSplit.partition() == null ? null : BinaryString.fromString(Arrays.toString(partitionConverter.convert(dataSplit.partition())));
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = () -> partitionId;
            supplierArray[1] = dataFileMeta::rowCount;
            supplierArray[2] = dataFileMeta::fileSize;
            Supplier[] fields = supplierArray;
            return new LazyGenericRow(fields);
        }
    }

    private static class PartitionsSplit
    implements Split {
        private static final long serialVersionUID = 1L;
        private final FileStoreTable storeTable;

        private PartitionsSplit(FileStoreTable storeTable) {
            this.storeTable = storeTable;
        }

        @Override
        public long rowCount() {
            TableScan.Plan plan = this.plan();
            return plan.splits().stream().map(s -> ((DataSplit)s).partition()).collect(Collectors.toSet()).size();
        }

        private TableScan.Plan plan() {
            return this.storeTable.newScan().plan();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionsSplit that = (PartitionsSplit)o;
            return Objects.equals(this.storeTable, that.storeTable);
        }

        public int hashCode() {
            return Objects.hash(this.storeTable);
        }
    }

    private static class PartitionsScan
    extends ReadOnceTableScan {
        private final FileStoreTable storeTable;

        private PartitionsScan(FileStoreTable storeTable) {
            this.storeTable = storeTable;
        }

        @Override
        public InnerTableScan withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public TableScan.Plan innerPlan() {
            return () -> Collections.singletonList(new PartitionsSplit(this.storeTable));
        }
    }
}

