/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.types;

import java.util.Objects;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.DataTypeVisitor;

@Public
public class DecimalType
extends DataType {
    private static final long serialVersionUID = 1L;
    public static final int MIN_PRECISION = 1;
    public static final int MAX_PRECISION = 38;
    public static final int DEFAULT_PRECISION = 10;
    public static final int MIN_SCALE = 0;
    public static final int DEFAULT_SCALE = 0;
    private static final String FORMAT = "DECIMAL(%d, %d)";
    private final int precision;
    private final int scale;

    public DecimalType(boolean isNullable, int precision, int scale) {
        super(isNullable, DataTypeRoot.DECIMAL);
        if (precision < 1 || precision > 38) {
            throw new IllegalArgumentException(String.format("Decimal precision must be between %d and %d (both inclusive).", 1, 38));
        }
        if (scale < 0 || scale > precision) {
            throw new IllegalArgumentException(String.format("Decimal scale must be between %d and the precision %d (both inclusive).", 0, precision));
        }
        this.precision = precision;
        this.scale = scale;
    }

    public DecimalType(int precision, int scale) {
        this(true, precision, scale);
    }

    public DecimalType(int precision) {
        this(precision, 0);
    }

    public DecimalType() {
        this(10);
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    public DataType copy(boolean isNullable) {
        return new DecimalType(isNullable, this.precision, this.scale);
    }

    @Override
    public String asSQLString() {
        return this.withNullability(FORMAT, this.precision, this.scale);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DecimalType that = (DecimalType)o;
        return this.precision == that.precision && this.scale == that.scale;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.precision, this.scale);
    }

    @Override
    public <R> R accept(DataTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }
}

