/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.io.DataInputDeserializer;
import org.apache.paimon.io.DataOutputSerializer;
import org.apache.paimon.utils.Preconditions;

public final class ListDelimitedSerializer {
    private static final byte DELIMITER = 44;
    private final DataInputDeserializer dataInputView = new DataInputDeserializer();
    private final DataOutputSerializer dataOutputView = new DataOutputSerializer(128);

    public <T> List<T> deserializeList(byte[] valueBytes, Serializer<T> elementSerializer) {
        T next;
        if (valueBytes == null) {
            return null;
        }
        this.dataInputView.setBuffer(valueBytes);
        ArrayList<T> result = new ArrayList<T>();
        while ((next = ListDelimitedSerializer.deserializeNextElement(this.dataInputView, elementSerializer)) != null) {
            result.add(next);
        }
        return result;
    }

    public <T> byte[] serializeList(List<T> valueList, Serializer<T> elementSerializer) throws IOException {
        this.dataOutputView.clear();
        boolean first = true;
        for (T value : valueList) {
            Preconditions.checkNotNull(value, "You cannot add null to a value list.");
            if (first) {
                first = false;
            } else {
                this.dataOutputView.write(44);
            }
            elementSerializer.serialize(value, this.dataOutputView);
        }
        return this.dataOutputView.getCopyOfBuffer();
    }

    public static <T> T deserializeNextElement(DataInputDeserializer in, Serializer<T> elementSerializer) {
        try {
            if (in.available() > 0) {
                T element = elementSerializer.deserialize(in);
                if (in.available() > 0) {
                    in.readByte();
                }
                return element;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected list element deserialization failure", e);
        }
        return null;
    }
}

