/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

public class MathUtils {
    public static int roundDownToPowerOf2(int value) {
        return Integer.highestOneBit(value);
    }

    public static int log2strict(int value) throws ArithmeticException, IllegalArgumentException {
        if (value == 0) {
            throw new ArithmeticException("Logarithm of zero is undefined.");
        }
        if ((value & value - 1) != 0) {
            throw new IllegalArgumentException("The given value " + value + " is not a power of two.");
        }
        return 31 - Integer.numberOfLeadingZeros(value);
    }
}

