/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.deletionvectors;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.deletionvectors.BitmapDeletionVector;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.index.IndexFileMeta;

public class DeletionVectorsMaintainer {
    private final IndexFileHandler indexFileHandler;
    private final Map<String, DeletionVector> deletionVectors;
    private boolean modified;

    private DeletionVectorsMaintainer(IndexFileHandler fileHandler, @Nullable Long snapshotId, BinaryRow partition, int bucket) {
        this.indexFileHandler = fileHandler;
        IndexFileMeta indexFile = snapshotId == null ? null : (IndexFileMeta)fileHandler.scan(snapshotId, "DELETION_VECTORS", partition, bucket).orElse(null);
        this.deletionVectors = indexFile == null ? new HashMap<String, DeletionVector>() : new HashMap<String, DeletionVector>(this.indexFileHandler.readAllDeletionVectors(indexFile));
        this.modified = false;
    }

    public void notifyNewDeletion(String fileName, long position) {
        DeletionVector deletionVector = this.deletionVectors.computeIfAbsent(fileName, k -> new BitmapDeletionVector());
        if (deletionVector.checkedDelete(position)) {
            this.modified = true;
        }
    }

    public void removeDeletionVectorOf(String fileName) {
        if (this.deletionVectors.containsKey(fileName)) {
            this.deletionVectors.remove(fileName);
            this.modified = true;
        }
    }

    public List<IndexFileMeta> prepareCommit() {
        if (this.modified) {
            IndexFileMeta entry = this.indexFileHandler.writeDeletionVectorsIndex(this.deletionVectors);
            this.modified = false;
            return Collections.singletonList(entry);
        }
        return Collections.emptyList();
    }

    public Optional<DeletionVector> deletionVectorOf(String fileName) {
        return Optional.ofNullable(this.deletionVectors.get(fileName));
    }

    @VisibleForTesting
    public Map<String, DeletionVector> deletionVectors() {
        return this.deletionVectors;
    }

    public static class Factory {
        private final IndexFileHandler handler;

        public Factory(IndexFileHandler handler) {
            this.handler = handler;
        }

        public DeletionVectorsMaintainer createOrRestore(@Nullable Long snapshotId, BinaryRow partition, int bucket) {
            return new DeletionVectorsMaintainer(this.handler, snapshotId, partition, bucket);
        }
    }
}

