/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.FileStore;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.deletionvectors.DeletionVectorsIndexFile;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.index.HashIndexFile;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.manifest.IndexManifestFile;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.metastore.AddPartitionTagCallback;
import org.apache.paimon.metastore.MetastoreClient;
import org.apache.paimon.operation.FileStoreCommitImpl;
import org.apache.paimon.operation.PartitionExpire;
import org.apache.paimon.operation.SnapshotDeletion;
import org.apache.paimon.operation.TagDeletion;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.service.ServiceManager;
import org.apache.paimon.stats.StatsFile;
import org.apache.paimon.stats.StatsFileHandler;
import org.apache.paimon.table.CatalogEnvironment;
import org.apache.paimon.table.sink.CallbackUtils;
import org.apache.paimon.table.sink.TagCallback;
import org.apache.paimon.tag.TagAutoManager;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.SegmentsCache;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;

abstract class AbstractFileStore<T>
implements FileStore<T> {
    protected final FileIO fileIO;
    protected final SchemaManager schemaManager;
    protected final TableSchema schema;
    protected final CoreOptions options;
    protected final RowType partitionType;
    private final CatalogEnvironment catalogEnvironment;
    @Nullable
    private final SegmentsCache<String> writeManifestCache;

    protected AbstractFileStore(FileIO fileIO, SchemaManager schemaManager, TableSchema schema, CoreOptions options, RowType partitionType, CatalogEnvironment catalogEnvironment) {
        this.fileIO = fileIO;
        this.schemaManager = schemaManager;
        this.schema = schema;
        this.options = options;
        this.partitionType = partitionType;
        this.catalogEnvironment = catalogEnvironment;
        MemorySize writeManifestCache = options.writeManifestCache();
        this.writeManifestCache = writeManifestCache.getBytes() == 0L ? null : new SegmentsCache(options.pageSize(), writeManifestCache);
    }

    @Override
    public FileStorePathFactory pathFactory() {
        return new FileStorePathFactory(this.options.path(), this.partitionType, this.options.partitionDefaultName(), this.options.fileFormat().getFormatIdentifier());
    }

    @Override
    public SnapshotManager snapshotManager() {
        return new SnapshotManager(this.fileIO, this.options.path());
    }

    @Override
    public ManifestFile.Factory manifestFileFactory() {
        return this.manifestFileFactory(false);
    }

    protected ManifestFile.Factory manifestFileFactory(boolean forWrite) {
        return new ManifestFile.Factory(this.fileIO, this.schemaManager, this.partitionType, this.options.manifestFormat(), this.pathFactory(), this.options.manifestTargetSize().getBytes(), forWrite ? this.writeManifestCache : null);
    }

    @Override
    public ManifestList.Factory manifestListFactory() {
        return this.manifestListFactory(false);
    }

    protected ManifestList.Factory manifestListFactory(boolean forWrite) {
        return new ManifestList.Factory(this.fileIO, this.options.manifestFormat(), this.pathFactory(), forWrite ? this.writeManifestCache : null);
    }

    protected IndexManifestFile.Factory indexManifestFileFactory() {
        return new IndexManifestFile.Factory(this.fileIO, this.options.manifestFormat(), this.pathFactory());
    }

    @Override
    public IndexFileHandler newIndexFileHandler() {
        return new IndexFileHandler(this.snapshotManager(), this.pathFactory().indexFileFactory(), this.indexManifestFileFactory().create(), new HashIndexFile(this.fileIO, this.pathFactory().indexFileFactory()), new DeletionVectorsIndexFile(this.fileIO, this.pathFactory().indexFileFactory()));
    }

    @Override
    public StatsFileHandler newStatsFileHandler() {
        return new StatsFileHandler(this.snapshotManager(), this.schemaManager, new StatsFile(this.fileIO, this.pathFactory().statsFileFactory()));
    }

    @Override
    public RowType partitionType() {
        return this.partitionType;
    }

    @Override
    public CoreOptions options() {
        return this.options;
    }

    @Override
    public boolean mergeSchema(RowType rowType, boolean allowExplicitCast) {
        return this.schemaManager.mergeSchema(rowType, allowExplicitCast);
    }

    @Override
    public FileStoreCommitImpl newCommit(String commitUser) {
        return this.newCommit(commitUser, "main");
    }

    @Override
    public FileStoreCommitImpl newCommit(String commitUser, String branchName) {
        return new FileStoreCommitImpl(this.fileIO, this.schemaManager, commitUser, this.partitionType, this.options.partitionDefaultName(), this.pathFactory(), this.snapshotManager(), this.manifestFileFactory(), this.manifestListFactory(), this.indexManifestFileFactory(), this.newScan(), this.options.bucket(), this.options.manifestTargetSize(), this.options.manifestFullCompactionThresholdSize(), this.options.manifestMergeMinCount(), this.partitionType.getFieldCount() > 0 && this.options.dynamicPartitionOverwrite(), this.newKeyComparator(), branchName, this.newStatsFileHandler());
    }

    @Override
    public SnapshotDeletion newSnapshotDeletion() {
        return new SnapshotDeletion(this.fileIO, this.pathFactory(), this.manifestFileFactory().create(), this.manifestListFactory().create(), this.newIndexFileHandler(), this.newStatsFileHandler());
    }

    @Override
    public TagManager newTagManager() {
        return new TagManager(this.fileIO, this.options.path());
    }

    @Override
    public TagDeletion newTagDeletion() {
        return new TagDeletion(this.fileIO, this.pathFactory(), this.manifestFileFactory().create(), this.manifestListFactory().create(), this.newIndexFileHandler(), this.newStatsFileHandler());
    }

    public abstract Comparator<InternalRow> newKeyComparator();

    @Override
    @Nullable
    public PartitionExpire newPartitionExpire(String commitUser) {
        Duration partitionExpireTime = this.options.partitionExpireTime();
        if (partitionExpireTime == null || this.partitionType().getFieldCount() == 0) {
            return null;
        }
        return new PartitionExpire(this.partitionType(), partitionExpireTime, this.options.partitionExpireCheckInterval(), this.options.partitionTimestampPattern(), this.options.partitionTimestampFormatter(), this.newScan(), this.newCommit(commitUser));
    }

    @Override
    public TagAutoManager newTagCreationManager() {
        return TagAutoManager.create(this.options, this.snapshotManager(), this.newTagManager(), this.newTagDeletion(), this.createTagCallbacks());
    }

    @Override
    public List<TagCallback> createTagCallbacks() {
        ArrayList<TagCallback> callbacks = new ArrayList<TagCallback>(CallbackUtils.loadTagCallbacks(this.options));
        String partitionField = this.options.tagToPartitionField();
        MetastoreClient.Factory metastoreClientFactory = this.catalogEnvironment.metastoreClientFactory();
        if (partitionField != null && metastoreClientFactory != null) {
            callbacks.add(new AddPartitionTagCallback(metastoreClientFactory.create(), partitionField));
        }
        return callbacks;
    }

    @Override
    public ServiceManager newServiceManager() {
        return new ServiceManager(this.fileIO, this.options.path());
    }
}

