/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.io.RollingFileWriter;
import org.apache.paimon.manifest.FileEntry;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.partition.PartitionPredicate;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.stats.BinaryTableStats;
import org.apache.paimon.stats.FieldStatsArraySerializer;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.utils.IOUtils;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.RowDataToObjectArrayConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestFileMeta {
    private static final Logger LOG = LoggerFactory.getLogger(ManifestFileMeta.class);
    private final String fileName;
    private final long fileSize;
    private final long numAddedFiles;
    private final long numDeletedFiles;
    private final BinaryTableStats partitionStats;
    private final long schemaId;

    public ManifestFileMeta(String fileName, long fileSize, long numAddedFiles, long numDeletedFiles, BinaryTableStats partitionStats, long schemaId) {
        this.fileName = fileName;
        this.fileSize = fileSize;
        this.numAddedFiles = numAddedFiles;
        this.numDeletedFiles = numDeletedFiles;
        this.partitionStats = partitionStats;
        this.schemaId = schemaId;
    }

    public String fileName() {
        return this.fileName;
    }

    public long fileSize() {
        return this.fileSize;
    }

    public long numAddedFiles() {
        return this.numAddedFiles;
    }

    public long numDeletedFiles() {
        return this.numDeletedFiles;
    }

    public BinaryTableStats partitionStats() {
        return this.partitionStats;
    }

    public long schemaId() {
        return this.schemaId;
    }

    public static RowType schema() {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        fields.add(new DataField(0, "_FILE_NAME", new VarCharType(false, Integer.MAX_VALUE)));
        fields.add(new DataField(1, "_FILE_SIZE", new BigIntType(false)));
        fields.add(new DataField(2, "_NUM_ADDED_FILES", new BigIntType(false)));
        fields.add(new DataField(3, "_NUM_DELETED_FILES", new BigIntType(false)));
        fields.add(new DataField(4, "_PARTITION_STATS", FieldStatsArraySerializer.schema()));
        fields.add(new DataField(5, "_SCHEMA_ID", new BigIntType(false)));
        return new RowType(fields);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ManifestFileMeta)) {
            return false;
        }
        ManifestFileMeta that = (ManifestFileMeta)o;
        return Objects.equals(this.fileName, that.fileName) && this.fileSize == that.fileSize && this.numAddedFiles == that.numAddedFiles && this.numDeletedFiles == that.numDeletedFiles && Objects.equals(this.partitionStats, that.partitionStats) && this.schemaId == that.schemaId;
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.fileSize, this.numAddedFiles, this.numDeletedFiles, this.partitionStats, this.schemaId);
    }

    public String toString() {
        return String.format("{%s, %d, %d, %d, %s, %d}", this.fileName, this.fileSize, this.numAddedFiles, this.numDeletedFiles, this.partitionStats, this.schemaId);
    }

    public static List<ManifestFileMeta> merge(List<ManifestFileMeta> input, ManifestFile manifestFile, long suggestedMetaSize, int suggestedMinMetaCount, long manifestFullCompactionSize, RowType partitionType) {
        ArrayList<ManifestFileMeta> newMetas = new ArrayList<ManifestFileMeta>();
        try {
            Optional<List<ManifestFileMeta>> fullCompacted = ManifestFileMeta.tryFullCompaction(input, newMetas, manifestFile, suggestedMetaSize, manifestFullCompactionSize, partitionType);
            return fullCompacted.orElseGet(() -> ManifestFileMeta.tryMinorCompaction(input, newMetas, manifestFile, suggestedMetaSize, suggestedMinMetaCount));
        }
        catch (Throwable e) {
            for (ManifestFileMeta manifest : newMetas) {
                manifestFile.delete(manifest.fileName);
            }
            throw new RuntimeException(e);
        }
    }

    private static List<ManifestFileMeta> tryMinorCompaction(List<ManifestFileMeta> input, List<ManifestFileMeta> newMetas, ManifestFile manifestFile, long suggestedMetaSize, int suggestedMinMetaCount) {
        ArrayList<ManifestFileMeta> result = new ArrayList<ManifestFileMeta>();
        ArrayList<ManifestFileMeta> candidates = new ArrayList<ManifestFileMeta>();
        long totalSize = 0L;
        for (ManifestFileMeta manifest : input) {
            candidates.add(manifest);
            if ((totalSize += manifest.fileSize) < suggestedMetaSize) continue;
            ManifestFileMeta.mergeCandidates(candidates, manifestFile, result, newMetas);
            candidates.clear();
            totalSize = 0L;
        }
        if (candidates.size() >= suggestedMinMetaCount) {
            ManifestFileMeta.mergeCandidates(candidates, manifestFile, result, newMetas);
        } else {
            result.addAll(candidates);
        }
        return result;
    }

    private static void mergeCandidates(List<ManifestFileMeta> candidates, ManifestFile manifestFile, List<ManifestFileMeta> result, List<ManifestFileMeta> newMetas) {
        if (candidates.size() == 1) {
            result.add(candidates.get(0));
            return;
        }
        LinkedHashMap<FileEntry.Identifier, ManifestEntry> map = new LinkedHashMap<FileEntry.Identifier, ManifestEntry>();
        FileEntry.mergeEntries(manifestFile, candidates, map);
        if (!map.isEmpty()) {
            List<ManifestFileMeta> merged = manifestFile.write(new ArrayList<ManifestEntry>(map.values()));
            result.addAll(merged);
            newMetas.addAll(merged);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<List<ManifestFileMeta>> tryFullCompaction(List<ManifestFileMeta> inputs, List<ManifestFileMeta> newMetas, ManifestFile manifestFile, long suggestedMetaSize, long sizeTrigger, RowType partitionType) throws Exception {
        int j;
        int i;
        ArrayList<ManifestFileMeta> base = new ArrayList<ManifestFileMeta>();
        int totalManifestSize = 0;
        for (i = 0; i < inputs.size(); ++i) {
            ManifestFileMeta file = inputs.get(i);
            if (file.numDeletedFiles != 0L || file.fileSize < suggestedMetaSize) break;
            base.add(file);
            totalManifestSize = (int)((long)totalManifestSize + file.fileSize);
        }
        ArrayList<ManifestFileMeta> delta = new ArrayList<ManifestFileMeta>();
        long deltaDeleteFileNum = 0L;
        long totalDeltaFileSize = 0L;
        while (i < inputs.size()) {
            ManifestFileMeta file = inputs.get(i);
            delta.add(file);
            totalManifestSize = (int)((long)totalManifestSize + file.fileSize);
            deltaDeleteFileNum += file.numDeletedFiles();
            totalDeltaFileSize += file.fileSize();
            ++i;
        }
        if (totalDeltaFileSize < sizeTrigger) {
            return Optional.empty();
        }
        LOG.info("Start Manifest File Full Compaction, pick the number of delete file: {}, total manifest file size: {}", (Object)deltaDeleteFileNum, (Object)totalManifestSize);
        LinkedHashMap<FileEntry.Identifier, ManifestEntry> deltaMerged = new LinkedHashMap<FileEntry.Identifier, ManifestEntry>();
        FileEntry.mergeEntries(manifestFile, delta, deltaMerged);
        ArrayList<ManifestFileMeta> result = new ArrayList<ManifestFileMeta>();
        if (partitionType.getFieldCount() > 0) {
            Set<BinaryRow> deletePartitions = ManifestFileMeta.computeDeletePartitions(deltaMerged);
            Optional<Predicate> predicateOpt = ManifestFileMeta.convertPartitionToPredicate(partitionType, deletePartitions);
            if (predicateOpt.isPresent()) {
                Predicate predicate = predicateOpt.get();
                for (j = 0; j < base.size(); ++j) {
                    ManifestFileMeta file = (ManifestFileMeta)base.get(j);
                    if (!predicate.test(file.numAddedFiles + file.numDeletedFiles, file.partitionStats.minValues(), file.partitionStats.maxValues(), file.partitionStats.nullCounts())) {
                        result.add(file);
                        continue;
                    }
                    break;
                }
            } else {
                j = base.size();
                result.addAll(base);
            }
        }
        HashSet deleteEntries = new HashSet();
        deltaMerged.forEach((k, v) -> {
            if (v.kind() == FileKind.DELETE) {
                deleteEntries.add(k);
            }
        });
        ArrayList<ManifestEntry> mergedEntries = new ArrayList<ManifestEntry>();
        while (j < base.size()) {
            ManifestFileMeta file = (ManifestFileMeta)base.get(j);
            boolean contains = false;
            for (ManifestEntry manifestEntry : manifestFile.read(file.fileName, file.fileSize)) {
                Preconditions.checkArgument(manifestEntry.kind() == FileKind.ADD);
                if (deleteEntries.contains(manifestEntry.identifier())) {
                    contains = true;
                    continue;
                }
                mergedEntries.add(manifestEntry);
            }
            if (contains) {
                ++j;
                break;
            }
            mergedEntries.clear();
            result.add(file);
            ++j;
        }
        RollingFileWriter<ManifestEntry, ManifestFileMeta> writer = manifestFile.createRollingWriter();
        Exception exception = null;
        try {
            for (ManifestEntry manifestEntry : mergedEntries) {
                writer.write(manifestEntry);
            }
            for (Supplier supplier : FileEntry.readManifestEntries(manifestFile, base.subList(j, base.size()))) {
                for (ManifestEntry entry : (List)supplier.get()) {
                    Preconditions.checkArgument(entry.kind() == FileKind.ADD);
                    if (deleteEntries.contains(entry.identifier())) continue;
                    writer.write(entry);
                }
            }
            for (ManifestEntry manifestEntry : deltaMerged.values()) {
                if (manifestEntry.kind() != FileKind.ADD) continue;
                writer.write(manifestEntry);
            }
        }
        catch (Exception e) {
            exception = e;
        }
        finally {
            if (exception != null) {
                IOUtils.closeQuietly(writer);
                throw exception;
            }
            writer.close();
        }
        Object merged = writer.result();
        result.addAll((Collection<ManifestFileMeta>)merged);
        newMetas.addAll((Collection<ManifestFileMeta>)merged);
        return Optional.of(result);
    }

    private static Set<BinaryRow> computeDeletePartitions(Map<FileEntry.Identifier, ManifestEntry> deltaMerged) {
        HashSet<BinaryRow> partitions = new HashSet<BinaryRow>();
        for (ManifestEntry manifestEntry : deltaMerged.values()) {
            if (manifestEntry.kind() != FileKind.DELETE) continue;
            BinaryRow partition = manifestEntry.partition();
            partitions.add(partition);
        }
        return partitions;
    }

    private static Optional<Predicate> convertPartitionToPredicate(RowType partitionType, Set<BinaryRow> partitions) {
        Optional<Predicate> predicateOpt;
        if (!partitions.isEmpty()) {
            RowDataToObjectArrayConverter rowArrayConverter = new RowDataToObjectArrayConverter(partitionType);
            List<Predicate> predicateList = partitions.stream().map(rowArrayConverter::convert).map(values -> PartitionPredicate.createPartitionPredicate(partitionType, values)).collect(Collectors.toList());
            predicateOpt = Optional.of(PredicateBuilder.or(predicateList));
        } else {
            predicateOpt = Optional.empty();
        }
        return predicateOpt;
    }
}

