/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.hive.LocationHelper;

public final class TBPropertiesLocationHelper
implements LocationHelper {
    @Override
    public void createPathIfRequired(Path path, FileIO fileIO) throws IOException {
        if (!fileIO.exists(path)) {
            fileIO.mkdirs(path);
        }
    }

    @Override
    public void dropPathIfRequired(Path path, FileIO fileIO) throws IOException {
        if (fileIO.exists(path)) {
            fileIO.delete(path, true);
        }
    }

    @Override
    public void specifyTableLocation(Table table, String location) {
        table.getParameters().put("paimon_location", location);
    }

    @Override
    public String getTableLocation(Table table) {
        String location = (String)table.getParameters().get("paimon_location");
        if (location != null) {
            return location;
        }
        return table.getSd().getLocation();
    }

    @Override
    public void specifyDatabaseLocation(Path path, Database database) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (database.getParameters() != null) {
            properties.putAll(database.getParameters());
        }
        properties.put("paimon_location", path.toString());
        database.setParameters(properties);
        database.setLocationUri(null);
    }

    @Override
    public String getDatabaseLocation(Database database) {
        String location = (String)database.getParameters().get("paimon_location");
        if (location != null) {
            return location;
        }
        return database.getLocationUri();
    }
}

