/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.threeten.extra;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.ParsePosition;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class Temporals {
    private Temporals() {
    }

    public static TemporalAdjuster nextWorkingDay() {
        return Adjuster.NEXT_WORKING;
    }

    public static TemporalAdjuster nextWorkingDayOrSame() {
        return Adjuster.NEXT_WORKING_OR_SAME;
    }

    public static TemporalAdjuster previousWorkingDay() {
        return Adjuster.PREVIOUS_WORKING;
    }

    public static TemporalAdjuster previousWorkingDayOrSame() {
        return Adjuster.PREVIOUS_WORKING_OR_SAME;
    }

    public static <T> T parseFirstMatching(CharSequence text, TemporalQuery<T> query, DateTimeFormatter ... formatters) {
        Objects.requireNonNull(text, "text");
        Objects.requireNonNull(query, "query");
        Objects.requireNonNull(formatters, "formatters");
        if (formatters.length == 0) {
            throw new DateTimeParseException("No formatters specified", text, 0);
        }
        if (formatters.length == 1) {
            return formatters[0].parse(text, query);
        }
        for (DateTimeFormatter formatter : formatters) {
            try {
                ParsePosition pp = new ParsePosition(0);
                formatter.parseUnresolved(text, pp);
                int len = text.length();
                if (pp.getErrorIndex() != -1 || pp.getIndex() != len) continue;
                return formatter.parse(text, query);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        throw new DateTimeParseException("Text '" + text + "' could not be parsed", text, 0);
    }

    public static ChronoUnit chronoUnit(TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        switch (unit) {
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case DAYS: {
                return ChronoUnit.DAYS;
            }
        }
        throw new IllegalArgumentException("Unknown TimeUnit constant");
    }

    public static TimeUnit timeUnit(ChronoUnit unit) {
        Objects.requireNonNull(unit, "unit");
        switch (unit) {
            case NANOS: {
                return TimeUnit.NANOSECONDS;
            }
            case MICROS: {
                return TimeUnit.MICROSECONDS;
            }
            case MILLIS: {
                return TimeUnit.MILLISECONDS;
            }
            case SECONDS: {
                return TimeUnit.SECONDS;
            }
            case MINUTES: {
                return TimeUnit.MINUTES;
            }
            case HOURS: {
                return TimeUnit.HOURS;
            }
            case DAYS: {
                return TimeUnit.DAYS;
            }
        }
        throw new IllegalArgumentException("ChronoUnit cannot be converted to TimeUnit: " + unit);
    }

    public static long[] convertAmount(long amount, TemporalUnit fromUnit, TemporalUnit toUnit) {
        int toMonthFactor;
        Objects.requireNonNull(fromUnit, "fromUnit");
        Objects.requireNonNull(toUnit, "toUnit");
        Temporals.validateUnit(fromUnit);
        Temporals.validateUnit(toUnit);
        if (fromUnit.equals(toUnit)) {
            return new long[]{amount, 0L};
        }
        if (Temporals.isPrecise(fromUnit) && Temporals.isPrecise(toUnit)) {
            long toNanos;
            long fromNanos = fromUnit.getDuration().toNanos();
            if (fromNanos > (toNanos = toUnit.getDuration().toNanos())) {
                long multiple = fromNanos / toNanos;
                return new long[]{Math.multiplyExact(amount, multiple), 0L};
            }
            long multiple = toNanos / fromNanos;
            return new long[]{amount / multiple, amount % multiple};
        }
        int fromMonthFactor = Temporals.monthMonthFactor(fromUnit, fromUnit, toUnit);
        if (fromMonthFactor > (toMonthFactor = Temporals.monthMonthFactor(toUnit, fromUnit, toUnit))) {
            long multiple = fromMonthFactor / toMonthFactor;
            return new long[]{Math.multiplyExact(amount, multiple), 0L};
        }
        long multiple = toMonthFactor / fromMonthFactor;
        return new long[]{amount / multiple, amount % multiple};
    }

    private static void validateUnit(TemporalUnit unit) {
        if (unit instanceof ChronoUnit ? unit.equals(ChronoUnit.ERAS) || unit.equals(ChronoUnit.FOREVER) : !unit.equals(IsoFields.QUARTER_YEARS)) {
            throw new UnsupportedTemporalTypeException("Unsupported TemporalUnit: " + unit);
        }
    }

    private static boolean isPrecise(TemporalUnit unit) {
        return unit instanceof ChronoUnit && ((ChronoUnit)unit).compareTo(ChronoUnit.WEEKS) <= 0;
    }

    private static int monthMonthFactor(TemporalUnit unit, TemporalUnit fromUnit, TemporalUnit toUnit) {
        if (unit instanceof ChronoUnit) {
            switch ((ChronoUnit)unit) {
                case MONTHS: {
                    return 1;
                }
                case YEARS: {
                    return 12;
                }
                case DECADES: {
                    return 120;
                }
                case CENTURIES: {
                    return 1200;
                }
                case MILLENNIA: {
                    return 12000;
                }
            }
            throw new DateTimeException(String.format("Unable to convert between units: %s to %s", fromUnit, toUnit));
        }
        return 3;
    }

    public static BigDecimal durationToBigDecimalSeconds(Duration duration) {
        return BigDecimal.valueOf(duration.getSeconds()).add(BigDecimal.valueOf(duration.getNano(), 9));
    }

    public static Duration durationFromBigDecimalSeconds(BigDecimal seconds) {
        BigInteger nanos = seconds.setScale(9, RoundingMode.UP).max(BigDecimalSeconds.MIN).min(BigDecimalSeconds.MAX).unscaledValue();
        BigInteger[] secondsNanos = nanos.divideAndRemainder(BigInteger.valueOf(1000000000L));
        return Duration.ofSeconds(secondsNanos[0].longValue(), secondsNanos[1].intValue());
    }

    public static double durationToDoubleSeconds(Duration duration) {
        if (duration.getSeconds() < 1000000000L) {
            return (double)duration.toNanos() / 1.0E9;
        }
        return Temporals.durationToBigDecimalSeconds(duration).doubleValue();
    }

    public static Duration durationFromDoubleSeconds(double seconds) {
        return Temporals.durationFromBigDecimalSeconds(BigDecimal.valueOf(seconds));
    }

    public static Duration multiply(Duration duration, double multiplicand) {
        if (multiplicand == 0.0 || duration.isZero()) {
            return Duration.ZERO;
        }
        if (multiplicand == 1.0) {
            return duration;
        }
        BigDecimal amount = Temporals.durationToBigDecimalSeconds(duration);
        amount = amount.multiply(BigDecimal.valueOf(multiplicand));
        return Temporals.durationFromBigDecimalSeconds(amount);
    }

    private static final class BigDecimalSeconds {
        public static final BigDecimal MIN = BigDecimal.valueOf(Long.MIN_VALUE).add(BigDecimal.valueOf(0L, 9));
        public static final BigDecimal MAX = BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.valueOf(999999999L, 9));

        private BigDecimalSeconds() {
        }
    }

    private static enum Adjuster implements TemporalAdjuster
    {
        NEXT_WORKING{

            @Override
            public Temporal adjustInto(Temporal temporal) {
                int dow = temporal.get(ChronoField.DAY_OF_WEEK);
                switch (dow) {
                    case 6: {
                        return temporal.plus(2L, ChronoUnit.DAYS);
                    }
                    case 5: {
                        return temporal.plus(3L, ChronoUnit.DAYS);
                    }
                }
                return temporal.plus(1L, ChronoUnit.DAYS);
            }
        }
        ,
        PREVIOUS_WORKING{

            @Override
            public Temporal adjustInto(Temporal temporal) {
                int dow = temporal.get(ChronoField.DAY_OF_WEEK);
                switch (dow) {
                    case 1: {
                        return temporal.minus(3L, ChronoUnit.DAYS);
                    }
                    case 7: {
                        return temporal.minus(2L, ChronoUnit.DAYS);
                    }
                }
                return temporal.minus(1L, ChronoUnit.DAYS);
            }
        }
        ,
        NEXT_WORKING_OR_SAME{

            @Override
            public Temporal adjustInto(Temporal temporal) {
                int dow = temporal.get(ChronoField.DAY_OF_WEEK);
                switch (dow) {
                    case 6: {
                        return temporal.plus(2L, ChronoUnit.DAYS);
                    }
                    case 7: {
                        return temporal.plus(1L, ChronoUnit.DAYS);
                    }
                }
                return temporal;
            }
        }
        ,
        PREVIOUS_WORKING_OR_SAME{

            @Override
            public Temporal adjustInto(Temporal temporal) {
                int dow = temporal.get(ChronoField.DAY_OF_WEEK);
                switch (dow) {
                    case 6: {
                        return temporal.minus(1L, ChronoUnit.DAYS);
                    }
                    case 7: {
                        return temporal.minus(2L, ChronoUnit.DAYS);
                    }
                }
                return temporal;
            }
        };

    }
}

