/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg.manifest;

import org.apache.paimon.format.FileFormat;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.iceberg.IcebergPathFactory;
import org.apache.paimon.iceberg.manifest.IcebergManifestFileMeta;
import org.apache.paimon.iceberg.manifest.IcebergManifestFileMetaSerializer;
import org.apache.paimon.options.Options;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.ObjectsFile;
import org.apache.paimon.utils.PathFactory;

public class IcebergManifestList
extends ObjectsFile<IcebergManifestFileMeta> {
    public IcebergManifestList(FileIO fileIO, FormatReaderFactory readerFactory, FormatWriterFactory writerFactory, String compression, PathFactory pathFactory) {
        super(fileIO, new IcebergManifestFileMetaSerializer(), IcebergManifestFileMeta.schema(), readerFactory, writerFactory, compression, pathFactory, null);
    }

    public static IcebergManifestList create(FileStoreTable table, IcebergPathFactory pathFactory) {
        Options manifestListAvroOptions = Options.fromMap(table.options());
        manifestListAvroOptions.set("avro.row-name-mapping", "org.apache.paimon.avro.generated.record:manifest_file,manifest_file_partitions:r508");
        FileFormat manifestListAvro = FileFormat.getFileFormat(manifestListAvroOptions, "avro");
        return new IcebergManifestList(table.fileIO(), manifestListAvro.createReaderFactory(IcebergManifestFileMeta.schema()), manifestListAvro.createWriterFactory(IcebergManifestFileMeta.schema()), table.coreOptions().manifestCompression(), pathFactory.manifestListFactory());
    }
}

