/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.format.SimpleColStats;
import org.apache.paimon.format.SimpleStatsExtractor;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.StatsCollectingSingleFileWriter;
import org.apache.paimon.manifest.FileSource;
import org.apache.paimon.stats.SimpleStats;
import org.apache.paimon.stats.SimpleStatsConverter;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.StatsCollectorFactories;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueDataFileWriter
extends StatsCollectingSingleFileWriter<KeyValue, DataFileMeta> {
    private static final Logger LOG = LoggerFactory.getLogger(KeyValueDataFileWriter.class);
    private final RowType keyType;
    private final RowType valueType;
    private final long schemaId;
    private final int level;
    private final SimpleStatsConverter keyStatsConverter;
    private final SimpleStatsConverter valueStatsConverter;
    private final InternalRowSerializer keySerializer;
    private final FileSource fileSource;
    private BinaryRow minKey = null;
    private InternalRow maxKey = null;
    private long minSeqNumber = Long.MAX_VALUE;
    private long maxSeqNumber = Long.MIN_VALUE;
    private long deleteRecordCount = 0L;

    public KeyValueDataFileWriter(FileIO fileIO, FormatWriterFactory factory, Path path, Function<KeyValue, InternalRow> converter, RowType keyType, RowType valueType, @Nullable SimpleStatsExtractor simpleStatsExtractor, long schemaId, int level, String compression, CoreOptions options, FileSource fileSource) {
        super(fileIO, factory, path, converter, KeyValue.schema(keyType, valueType), simpleStatsExtractor, compression, StatsCollectorFactories.createStatsFactories(options, KeyValue.schema(keyType, valueType).getFieldNames()), options.asyncFileWrite());
        this.keyType = keyType;
        this.valueType = valueType;
        this.schemaId = schemaId;
        this.level = level;
        this.keyStatsConverter = new SimpleStatsConverter(keyType);
        this.valueStatsConverter = new SimpleStatsConverter(valueType);
        this.keySerializer = new InternalRowSerializer(keyType);
        this.fileSource = fileSource;
    }

    @Override
    public void write(KeyValue kv) throws IOException {
        super.write(kv);
        this.updateMinKey(kv);
        this.updateMaxKey(kv);
        this.updateMinSeqNumber(kv);
        this.updateMaxSeqNumber(kv);
        if (kv.valueKind().isRetract()) {
            ++this.deleteRecordCount;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Write to Path " + this.path + " key value " + kv.toString(this.keyType, this.valueType));
        }
    }

    private void updateMinKey(KeyValue kv) {
        if (this.minKey == null) {
            this.minKey = this.keySerializer.toBinaryRow(kv.key()).copy();
        }
    }

    private void updateMaxKey(KeyValue kv) {
        this.maxKey = kv.key();
    }

    private void updateMinSeqNumber(KeyValue kv) {
        this.minSeqNumber = Math.min(this.minSeqNumber, kv.sequenceNumber());
    }

    private void updateMaxSeqNumber(KeyValue kv) {
        this.maxSeqNumber = Math.max(this.maxSeqNumber, kv.sequenceNumber());
    }

    @Override
    @Nullable
    public DataFileMeta result() throws IOException {
        if (this.recordCount() == 0L) {
            return null;
        }
        SimpleColStats[] rowStats = this.fieldStats();
        int numKeyFields = this.keyType.getFieldCount();
        SimpleColStats[] keyFieldStats = Arrays.copyOfRange(rowStats, 0, numKeyFields);
        SimpleStats keyStats = this.keyStatsConverter.toBinary(keyFieldStats);
        SimpleColStats[] valFieldStats = Arrays.copyOfRange(rowStats, numKeyFields + 2, rowStats.length);
        SimpleStats valueStats = this.valueStatsConverter.toBinary(valFieldStats);
        return new DataFileMeta(this.path.getName(), this.fileIO.getFileSize(this.path), this.recordCount(), this.minKey, this.keySerializer.toBinaryRow(this.maxKey).copy(), keyStats, valueStats, this.minSeqNumber, this.maxSeqNumber, this.schemaId, this.level, this.deleteRecordCount, null, this.fileSource);
    }
}

