/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.ManifestReadThreadPool;
import org.apache.paimon.utils.Preconditions;

public interface FileEntry {
    public FileKind kind();

    public BinaryRow partition();

    public int bucket();

    public int level();

    public String fileName();

    public Identifier identifier();

    public BinaryRow minKey();

    public BinaryRow maxKey();

    public static <T extends FileEntry> Collection<T> mergeEntries(Iterable<T> entries) {
        LinkedHashMap map = new LinkedHashMap();
        FileEntry.mergeEntries(entries, map);
        return map.values();
    }

    public static void mergeEntries(ManifestFile manifestFile, List<ManifestFileMeta> manifestFiles, Map<Identifier, ManifestEntry> map, @Nullable Integer manifestReadParallelism) {
        FileEntry.mergeEntries(FileEntry.readManifestEntries(manifestFile, manifestFiles, manifestReadParallelism), map);
    }

    public static <T extends FileEntry> void mergeEntries(Iterable<T> entries, Map<Identifier, T> map) {
        block4: for (FileEntry entry : entries) {
            Identifier identifier = entry.identifier();
            switch (entry.kind()) {
                case ADD: {
                    Preconditions.checkState(!map.containsKey(identifier), "Trying to add file %s which is already added.", identifier);
                    map.put(identifier, entry);
                    continue block4;
                }
                case DELETE: {
                    if (map.containsKey(identifier)) {
                        map.remove(identifier);
                        continue block4;
                    }
                    map.put(identifier, entry);
                    continue block4;
                }
            }
            throw new UnsupportedOperationException("Unknown value kind " + entry.kind().name());
        }
    }

    public static Iterable<ManifestEntry> readManifestEntries(ManifestFile manifestFile, List<ManifestFileMeta> manifestFiles, @Nullable Integer manifestReadParallelism) {
        return ManifestReadThreadPool.sequentialBatchedExecute(file -> manifestFile.read(file.fileName(), file.fileSize()), manifestFiles, manifestReadParallelism);
    }

    public static class Identifier {
        public final BinaryRow partition;
        public final int bucket;
        public final int level;
        public final String fileName;
        private Integer hash;

        public Identifier(BinaryRow partition, int bucket, int level, String fileName) {
            this.partition = partition;
            this.bucket = bucket;
            this.level = level;
            this.fileName = fileName;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Identifier)) {
                return false;
            }
            Identifier that = (Identifier)o;
            return Objects.equals(this.partition, that.partition) && this.bucket == that.bucket && this.level == that.level && Objects.equals(this.fileName, that.fileName);
        }

        public int hashCode() {
            if (this.hash == null) {
                this.hash = Objects.hash(this.partition, this.bucket, this.level, this.fileName);
            }
            return this.hash;
        }

        public String toString() {
            return String.format("{%s, %d, %d, %s}", this.partition, this.bucket, this.level, this.fileName);
        }

        public String toString(FileStorePathFactory pathFactory) {
            return pathFactory.getPartitionString(this.partition) + ", bucket " + this.bucket + ", level " + this.level + ", file " + this.fileName;
        }
    }
}

