/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.catalog;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.catalog.Database;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.catalog.PropertyChange;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.partition.Partition;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.table.Table;
import org.apache.paimon.view.View;

@Public
public interface Catalog
extends AutoCloseable {
    public static final String SYSTEM_TABLE_SPLITTER = "$";
    public static final String SYSTEM_DATABASE_NAME = "sys";
    public static final String SYSTEM_BRANCH_PREFIX = "branch_";
    public static final String COMMENT_PROP = "comment";
    public static final String OWNER_PROP = "owner";
    public static final String DEFAULT_DATABASE = "default";
    public static final String DB_SUFFIX = ".db";
    public static final String DB_LOCATION_PROP = "location";
    public static final String TABLE_DEFAULT_OPTION_PREFIX = "table-default.";
    public static final String NUM_ROWS_PROP = "numRows";
    public static final String NUM_FILES_PROP = "numFiles";
    public static final String TOTAL_SIZE_PROP = "totalSize";
    public static final String LAST_UPDATE_TIME_PROP = "lastUpdateTime";

    public String warehouse();

    public FileIO fileIO();

    public Map<String, String> options();

    public boolean caseSensitive();

    public List<String> listDatabases();

    default public void createDatabase(String name, boolean ignoreIfExists) throws DatabaseAlreadyExistException {
        this.createDatabase(name, ignoreIfExists, Collections.emptyMap());
    }

    public void createDatabase(String var1, boolean var2, Map<String, String> var3) throws DatabaseAlreadyExistException;

    public Database getDatabase(String var1) throws DatabaseNotExistException;

    public void dropDatabase(String var1, boolean var2, boolean var3) throws DatabaseNotExistException, DatabaseNotEmptyException;

    public void alterDatabase(String var1, List<PropertyChange> var2, boolean var3) throws DatabaseNotExistException;

    public Table getTable(Identifier var1) throws TableNotExistException;

    public List<String> listTables(String var1) throws DatabaseNotExistException;

    public void dropTable(Identifier var1, boolean var2) throws TableNotExistException;

    public void createTable(Identifier var1, Schema var2, boolean var3) throws TableAlreadyExistException, DatabaseNotExistException;

    public void renameTable(Identifier var1, Identifier var2, boolean var3) throws TableNotExistException, TableAlreadyExistException;

    public void alterTable(Identifier var1, List<SchemaChange> var2, boolean var3) throws TableNotExistException, ColumnAlreadyExistException, ColumnNotExistException;

    default public void invalidateTable(Identifier identifier) {
    }

    public void createPartition(Identifier var1, Map<String, String> var2) throws TableNotExistException;

    public void dropPartition(Identifier var1, Map<String, String> var2) throws TableNotExistException, PartitionNotExistException;

    public List<Partition> listPartitions(Identifier var1) throws TableNotExistException;

    default public void alterTable(Identifier identifier, SchemaChange change, boolean ignoreIfNotExists) throws TableNotExistException, ColumnAlreadyExistException, ColumnNotExistException {
        this.alterTable(identifier, Collections.singletonList(change), ignoreIfNotExists);
    }

    default public View getView(Identifier identifier) throws ViewNotExistException {
        throw new ViewNotExistException(identifier);
    }

    default public void dropView(Identifier identifier, boolean ignoreIfNotExists) throws ViewNotExistException {
        throw new UnsupportedOperationException();
    }

    default public void createView(Identifier identifier, View view, boolean ignoreIfExists) throws ViewAlreadyExistException, DatabaseNotExistException {
        throw new UnsupportedOperationException();
    }

    default public List<String> listViews(String databaseName) throws DatabaseNotExistException {
        return Collections.emptyList();
    }

    default public void renameView(Identifier fromView, Identifier toView, boolean ignoreIfNotExists) throws ViewNotExistException, ViewAlreadyExistException {
        throw new UnsupportedOperationException();
    }

    default public void repairCatalog() {
        throw new UnsupportedOperationException();
    }

    default public void repairDatabase(String databaseName) {
        throw new UnsupportedOperationException();
    }

    default public void repairTable(Identifier identifier) throws TableNotExistException {
        throw new UnsupportedOperationException();
    }

    public static class ViewNotExistException
    extends Exception {
        private static final String MSG = "View %s does not exist.";
        private final Identifier identifier;

        public ViewNotExistException(Identifier identifier) {
            this(identifier, null);
        }

        public ViewNotExistException(Identifier identifier, Throwable cause) {
            super(String.format(MSG, identifier.getFullName()), cause);
            this.identifier = identifier;
        }

        public Identifier identifier() {
            return this.identifier;
        }
    }

    public static class ViewAlreadyExistException
    extends Exception {
        private static final String MSG = "View %s already exists.";
        private final Identifier identifier;

        public ViewAlreadyExistException(Identifier identifier) {
            this(identifier, null);
        }

        public ViewAlreadyExistException(Identifier identifier, Throwable cause) {
            super(String.format(MSG, identifier.getFullName()), cause);
            this.identifier = identifier;
        }

        public Identifier identifier() {
            return this.identifier;
        }
    }

    public static class ColumnNotExistException
    extends Exception {
        private static final String MSG = "Column %s does not exist in the %s table.";
        private final Identifier identifier;
        private final String column;

        public ColumnNotExistException(Identifier identifier, String column) {
            this(identifier, column, null);
        }

        public ColumnNotExistException(Identifier identifier, String column, Throwable cause) {
            super(String.format(MSG, column, identifier.getFullName()), cause);
            this.identifier = identifier;
            this.column = column;
        }

        public Identifier identifier() {
            return this.identifier;
        }

        public String column() {
            return this.column;
        }
    }

    public static class ColumnAlreadyExistException
    extends Exception {
        private static final String MSG = "Column %s already exists in the %s table.";
        private final Identifier identifier;
        private final String column;

        public ColumnAlreadyExistException(Identifier identifier, String column) {
            this(identifier, column, null);
        }

        public ColumnAlreadyExistException(Identifier identifier, String column, Throwable cause) {
            super(String.format(MSG, column, identifier.getFullName()), cause);
            this.identifier = identifier;
            this.column = column;
        }

        public Identifier identifier() {
            return this.identifier;
        }

        public String column() {
            return this.column;
        }
    }

    public static class PartitionNotExistException
    extends Exception {
        private static final String MSG = "Partition %s do not exist in the table %s.";
        private final Identifier identifier;
        private final Map<String, String> partitionSpec;

        public PartitionNotExistException(Identifier identifier, Map<String, String> partitionSpec) {
            this(identifier, partitionSpec, null);
        }

        public PartitionNotExistException(Identifier identifier, Map<String, String> partitionSpec, Throwable cause) {
            super(String.format(MSG, partitionSpec, identifier.getFullName()), cause);
            this.identifier = identifier;
            this.partitionSpec = partitionSpec;
        }

        public Identifier identifier() {
            return this.identifier;
        }

        public Map<String, String> partitionSpec() {
            return this.partitionSpec;
        }
    }

    public static class TableNotExistException
    extends Exception {
        private static final String MSG = "Table %s does not exist.";
        private final Identifier identifier;

        public TableNotExistException(Identifier identifier) {
            this(identifier, null);
        }

        public TableNotExistException(Identifier identifier, Throwable cause) {
            super(String.format(MSG, identifier.getFullName()), cause);
            this.identifier = identifier;
        }

        public Identifier identifier() {
            return this.identifier;
        }
    }

    public static class TableAlreadyExistException
    extends Exception {
        private static final String MSG = "Table %s already exists.";
        private final Identifier identifier;

        public TableAlreadyExistException(Identifier identifier) {
            this(identifier, null);
        }

        public TableAlreadyExistException(Identifier identifier, Throwable cause) {
            super(String.format(MSG, identifier.getFullName()), cause);
            this.identifier = identifier;
        }

        public Identifier identifier() {
            return this.identifier;
        }
    }

    public static class ProcessSystemDatabaseException
    extends IllegalArgumentException {
        private static final String MSG = "Can't do operation on system database.";

        public ProcessSystemDatabaseException() {
            super(MSG);
        }
    }

    public static class DatabaseNotExistException
    extends Exception {
        private static final String MSG = "Database %s does not exist.";
        private final String database;

        public DatabaseNotExistException(String database, Throwable cause) {
            super(String.format(MSG, database), cause);
            this.database = database;
        }

        public DatabaseNotExistException(String database) {
            this(database, null);
        }

        public String database() {
            return this.database;
        }
    }

    public static class DatabaseAlreadyExistException
    extends Exception {
        private static final String MSG = "Database %s already exists.";
        private final String database;

        public DatabaseAlreadyExistException(String database, Throwable cause) {
            super(String.format(MSG, database), cause);
            this.database = database;
        }

        public DatabaseAlreadyExistException(String database) {
            this(database, null);
        }

        public String database() {
            return this.database;
        }
    }

    public static class DatabaseNotEmptyException
    extends Exception {
        private static final String MSG = "Database %s is not empty.";
        private final String database;

        public DatabaseNotEmptyException(String database, Throwable cause) {
            super(String.format(MSG, database), cause);
            this.database = database;
        }

        public DatabaseNotEmptyException(String database) {
            this(database, null);
        }

        public String database() {
            return this.database;
        }
    }
}

