/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.reader;

import java.io.IOException;
import org.apache.paimon.data.columnar.writable.WritableBooleanVector;
import org.apache.paimon.data.columnar.writable.WritableIntVector;
import org.apache.paimon.format.parquet.reader.AbstractColumnReader;
import org.apache.paimon.shade.org.apache.parquet.column.ColumnDescriptor;
import org.apache.paimon.shade.org.apache.parquet.column.page.PageReadStore;
import org.apache.paimon.shade.org.apache.parquet.io.ParquetDecodingException;
import org.apache.paimon.shade.org.apache.parquet.schema.PrimitiveType;

public class BooleanColumnReader
extends AbstractColumnReader<WritableBooleanVector> {
    private int bitOffset;
    private byte currentByte = 0;

    public BooleanColumnReader(ColumnDescriptor descriptor, PageReadStore pageReadStore) throws IOException {
        super(descriptor, pageReadStore);
        this.checkTypeName(PrimitiveType.PrimitiveTypeName.BOOLEAN);
    }

    @Override
    protected void afterReadPage() {
        this.bitOffset = 0;
        this.currentByte = 0;
    }

    @Override
    protected void readBatchFromDictionaryIds(int rowId, int num, WritableBooleanVector column, WritableIntVector dictionaryIds) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void readBatch(int rowId, int num, WritableBooleanVector column) {
        int left = num;
        while (left > 0) {
            if (this.runLenDecoder.currentCount == 0) {
                this.runLenDecoder.readNextGroup();
            }
            int n = Math.min(left, this.runLenDecoder.currentCount);
            switch (this.runLenDecoder.mode) {
                case RLE: {
                    int i;
                    if (this.runLenDecoder.currentValue == this.maxDefLevel) {
                        for (i = 0; i < n; ++i) {
                            column.setBoolean(rowId + i, this.readBoolean());
                        }
                        break;
                    }
                    column.setNulls(rowId, n);
                    break;
                }
                case PACKED: {
                    int i;
                    for (i = 0; i < n; ++i) {
                        if (this.runLenDecoder.currentBuffer[this.runLenDecoder.currentBufferIdx++] == this.maxDefLevel) {
                            column.setBoolean(rowId + i, this.readBoolean());
                            continue;
                        }
                        column.setNullAt(rowId + i);
                    }
                    break;
                }
            }
            rowId += n;
            left -= n;
            this.runLenDecoder.currentCount -= n;
        }
    }

    @Override
    protected void skipBatch(int num) {
        int left = num;
        while (left > 0) {
            if (this.runLenDecoder.currentCount == 0) {
                this.runLenDecoder.readNextGroup();
            }
            int n = Math.min(left, this.runLenDecoder.currentCount);
            switch (this.runLenDecoder.mode) {
                case RLE: {
                    int i;
                    if (this.runLenDecoder.currentValue != this.maxDefLevel) break;
                    for (i = 0; i < n; ++i) {
                        this.readBoolean();
                    }
                    break;
                }
                case PACKED: {
                    int i;
                    for (i = 0; i < n; ++i) {
                        if (this.runLenDecoder.currentBuffer[this.runLenDecoder.currentBufferIdx++] != this.maxDefLevel) continue;
                        this.readBoolean();
                    }
                    break;
                }
            }
            left -= n;
            this.runLenDecoder.currentCount -= n;
        }
    }

    private boolean readBoolean() {
        if (this.bitOffset == 0) {
            try {
                this.currentByte = (byte)this.dataInputStream.read();
            }
            catch (IOException e) {
                throw new ParquetDecodingException("Failed to read a byte", e);
            }
        }
        boolean v = (this.currentByte & 1 << this.bitOffset) != 0;
        ++this.bitOffset;
        if (this.bitOffset == 8) {
            this.bitOffset = 0;
        }
        return v;
    }
}

