/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import javax.annotation.Nullable;
import org.apache.paimon.Snapshot;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.stats.Statistics;
import org.apache.paimon.table.ExpireSnapshots;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.sink.BatchWriteBuilder;
import org.apache.paimon.table.sink.StreamWriteBuilder;
import org.apache.paimon.table.source.ReadBuilder;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.SimpleFileReader;

@Public
public interface FormatTable
extends Table {
    public String location();

    public Format format();

    @Override
    public FormatTable copy(Map<String, String> var1);

    public static Format parseFormat(String fileFormat) {
        try {
            return Format.valueOf(fileFormat.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException("Format table unsupported file format: " + fileFormat + ". Supported formats: " + Arrays.toString((Object[])Format.values()));
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    default public Optional<Statistics> statistics() {
        return Optional.empty();
    }

    @Override
    default public OptionalLong latestSnapshotId() {
        throw new UnsupportedOperationException();
    }

    @Override
    default public Snapshot snapshot(long snapshotId) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public SimpleFileReader<ManifestFileMeta> manifestListReader() {
        throw new UnsupportedOperationException();
    }

    @Override
    default public SimpleFileReader<ManifestEntry> manifestFileReader() {
        throw new UnsupportedOperationException();
    }

    @Override
    default public SimpleFileReader<IndexManifestEntry> indexManifestFileReader() {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void rollbackTo(long snapshotId) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void createTag(String tagName, long fromSnapshotId) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void createTag(String tagName, long fromSnapshotId, Duration timeRetained) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void createTag(String tagName) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void createTag(String tagName, Duration timeRetained) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void renameTag(String tagName, String targetTagName) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void replaceTag(String tagName, Long fromSnapshotId, Duration timeRetained) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void deleteTag(String tagName) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void rollbackTo(String tagName) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void createBranch(String branchName) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void createBranch(String branchName, String tagName) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void deleteBranch(String branchName) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void fastForward(String branchName) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public ExpireSnapshots newExpireSnapshots() {
        throw new UnsupportedOperationException();
    }

    @Override
    default public ExpireSnapshots newExpireChangelog() {
        throw new UnsupportedOperationException();
    }

    @Override
    default public ReadBuilder newReadBuilder() {
        throw new UnsupportedOperationException();
    }

    @Override
    default public BatchWriteBuilder newBatchWriteBuilder() {
        throw new UnsupportedOperationException();
    }

    @Override
    default public StreamWriteBuilder newStreamWriteBuilder() {
        throw new UnsupportedOperationException();
    }

    public static class FormatTableImpl
    implements FormatTable {
        private final Identifier identifier;
        private final RowType rowType;
        private final List<String> partitionKeys;
        private final String location;
        private final Format format;
        private final Map<String, String> options;
        @Nullable
        private final String comment;

        public FormatTableImpl(Identifier identifier, RowType rowType, List<String> partitionKeys, String location, Format format, Map<String, String> options, @Nullable String comment) {
            this.identifier = identifier;
            this.rowType = rowType;
            this.partitionKeys = partitionKeys;
            this.location = location;
            this.format = format;
            this.options = options;
            this.comment = comment;
        }

        @Override
        public String name() {
            return this.identifier.getTableName();
        }

        @Override
        public String fullName() {
            return this.identifier.getFullName();
        }

        @Override
        public RowType rowType() {
            return this.rowType;
        }

        @Override
        public List<String> partitionKeys() {
            return this.partitionKeys;
        }

        @Override
        public List<String> primaryKeys() {
            return Collections.emptyList();
        }

        @Override
        public String location() {
            return this.location;
        }

        @Override
        public Format format() {
            return this.format;
        }

        @Override
        public Map<String, String> options() {
            return this.options;
        }

        @Override
        public Optional<String> comment() {
            return Optional.ofNullable(this.comment);
        }

        @Override
        public FormatTable copy(Map<String, String> dynamicOptions) {
            HashMap<String, String> newOptions = new HashMap<String, String>(this.options);
            newOptions.putAll(dynamicOptions);
            return new FormatTableImpl(this.identifier, this.rowType, this.partitionKeys, this.location, this.format, newOptions, this.comment);
        }
    }

    public static class Builder {
        private Identifier identifier;
        private RowType rowType;
        private List<String> partitionKeys;
        private String location;
        private Format format;
        private Map<String, String> options;
        @Nullable
        private String comment;

        public Builder identifier(Identifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder rowType(RowType rowType) {
            this.rowType = rowType;
            return this;
        }

        public Builder partitionKeys(List<String> partitionKeys) {
            this.partitionKeys = partitionKeys;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder format(Format format) {
            this.format = format;
            return this;
        }

        public Builder options(Map<String, String> options) {
            this.options = options;
            return this;
        }

        public Builder comment(@Nullable String comment) {
            this.comment = comment;
            return this;
        }

        public FormatTable build() {
            return new FormatTableImpl(this.identifier, this.rowType, this.partitionKeys, this.location, this.format, this.options, this.comment);
        }
    }

    public static enum Format {
        ORC,
        PARQUET,
        CSV;

    }
}

