/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.annotation.Experimental;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFileMetaSerializer;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.table.DataTable;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.DataTableScan;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.StreamDataTableScan;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.BranchManager;
import org.apache.paimon.utils.IteratorRecordReader;
import org.apache.paimon.utils.SerializationUtils;
import org.apache.paimon.utils.SimpleFileReader;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;

@Experimental
public class FileMonitorTable
implements DataTable,
ReadonlyTable {
    private static final long serialVersionUID = 1L;
    private final FileStoreTable wrapped;
    private static final RowType ROW_TYPE = RowType.of(new DataType[]{new BigIntType(false), SerializationUtils.newBytesType(false), new IntType(false), SerializationUtils.newBytesType(false), SerializationUtils.newBytesType(false)}, new String[]{"_SNAPSHOT_ID", "_PARTITION", "_BUCKET", "_BEFORE_FILES", "_DATA_FILES"});

    public FileMonitorTable(FileStoreTable wrapped) {
        HashMap<String, String> dynamicOptions = new HashMap<String, String>();
        dynamicOptions.put(CoreOptions.STREAM_SCAN_MODE.key(), CoreOptions.StreamScanMode.FILE_MONITOR.getValue());
        dynamicOptions.put(CoreOptions.SCAN_BOUNDED_WATERMARK.key(), null);
        this.wrapped = wrapped.copy(dynamicOptions);
    }

    @Override
    public OptionalLong latestSnapshotId() {
        return this.wrapped.latestSnapshotId();
    }

    @Override
    public Snapshot snapshot(long snapshotId) {
        return this.wrapped.snapshot(snapshotId);
    }

    @Override
    public SimpleFileReader<ManifestFileMeta> manifestListReader() {
        return this.wrapped.manifestListReader();
    }

    @Override
    public SimpleFileReader<ManifestEntry> manifestFileReader() {
        return this.wrapped.manifestFileReader();
    }

    @Override
    public SimpleFileReader<IndexManifestEntry> indexManifestFileReader() {
        return this.wrapped.indexManifestFileReader();
    }

    @Override
    public Path location() {
        return this.wrapped.location();
    }

    @Override
    public SnapshotManager snapshotManager() {
        return this.wrapped.snapshotManager();
    }

    @Override
    public SchemaManager schemaManager() {
        return this.wrapped.schemaManager();
    }

    @Override
    public TagManager tagManager() {
        return this.wrapped.tagManager();
    }

    @Override
    public BranchManager branchManager() {
        return this.wrapped.branchManager();
    }

    @Override
    public DataTable switchToBranch(String branchName) {
        return new FileMonitorTable(this.wrapped.switchToBranch(branchName));
    }

    @Override
    public String name() {
        return "__internal_file_monitor_" + this.wrapped.location().getName();
    }

    @Override
    public RowType rowType() {
        return ROW_TYPE;
    }

    @Override
    public Map<String, String> options() {
        return this.wrapped.options();
    }

    @Override
    public List<String> primaryKeys() {
        return Collections.emptyList();
    }

    @Override
    public SnapshotReader newSnapshotReader() {
        return this.wrapped.newSnapshotReader();
    }

    @Override
    public DataTableScan newScan() {
        return this.wrapped.newScan();
    }

    @Override
    public StreamDataTableScan newStreamScan() {
        return this.wrapped.newStreamScan();
    }

    @Override
    public CoreOptions coreOptions() {
        return this.wrapped.coreOptions();
    }

    @Override
    public InnerTableRead newRead() {
        return new BucketsRead();
    }

    @Override
    public FileMonitorTable copy(Map<String, String> dynamicOptions) {
        return new FileMonitorTable((FileStoreTable)this.wrapped.copy((Map)dynamicOptions));
    }

    @Override
    public FileIO fileIO() {
        return this.wrapped.fileIO();
    }

    public static RowType getRowType() {
        return ROW_TYPE;
    }

    public static InternalRow toRow(FileChange change) throws IOException {
        DataFileMetaSerializer fileSerializer = new DataFileMetaSerializer();
        return GenericRow.of(change.snapshotId(), SerializationUtils.serializeBinaryRow(change.partition()), change.bucket(), fileSerializer.serializeList(change.beforeFiles()), fileSerializer.serializeList(change.dataFiles()));
    }

    public static FileChange toFileChange(InternalRow row) throws IOException {
        DataFileMetaSerializer fileSerializer = new DataFileMetaSerializer();
        return new FileChange(row.getLong(0), SerializationUtils.deserializeBinaryRow(row.getBinary(1)), row.getInt(2), fileSerializer.deserializeList(row.getBinary(3)), fileSerializer.deserializeList(row.getBinary(4)));
    }

    public static class FileChange {
        private final long snapshotId;
        private final BinaryRow partition;
        private final int bucket;
        private final List<DataFileMeta> beforeFiles;
        private final List<DataFileMeta> dataFiles;

        public FileChange(long snapshotId, BinaryRow partition, int bucket, List<DataFileMeta> beforeFiles, List<DataFileMeta> dataFiles) {
            this.snapshotId = snapshotId;
            this.partition = partition;
            this.bucket = bucket;
            this.beforeFiles = beforeFiles;
            this.dataFiles = dataFiles;
        }

        public long snapshotId() {
            return this.snapshotId;
        }

        public BinaryRow partition() {
            return this.partition;
        }

        public int bucket() {
            return this.bucket;
        }

        public List<DataFileMeta> beforeFiles() {
            return this.beforeFiles;
        }

        public List<DataFileMeta> dataFiles() {
            return this.dataFiles;
        }

        public String toString() {
            return "FileChange{snapshotId=" + this.snapshotId + ", partition=" + this.partition + ", bucket=" + this.bucket + ", beforeFiles=" + this.beforeFiles + ", dataFiles=" + this.dataFiles + '}';
        }
    }

    private static class BucketsRead
    implements InnerTableRead {
        private BucketsRead() {
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) throws IOException {
            if (!(split instanceof DataSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            DataSplit dataSplit = (DataSplit)split;
            FileChange change = new FileChange(dataSplit.snapshotId(), dataSplit.partition(), dataSplit.bucket(), dataSplit.beforeFiles(), dataSplit.dataFiles());
            return new IteratorRecordReader<InternalRow>(Collections.singletonList(FileMonitorTable.toRow(change)).iterator());
        }
    }
}

