/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact.aggregate;

import java.math.BigDecimal;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.mergetree.compact.aggregate.FieldAggregator;
import org.apache.paimon.types.DataType;

public class FieldProductAgg
extends FieldAggregator {
    private static final long serialVersionUID = 1L;

    public FieldProductAgg(String name, DataType dataType) {
        super(name, dataType);
    }

    @Override
    public Object agg(Object accumulator, Object inputField) {
        Comparable<Integer> product;
        if (accumulator == null || inputField == null) {
            return accumulator == null ? inputField : accumulator;
        }
        switch (this.fieldType.getTypeRoot()) {
            case DECIMAL: {
                Decimal mergeFieldDD = (Decimal)accumulator;
                Decimal inFieldDD = (Decimal)inputField;
                assert (mergeFieldDD.scale() == inFieldDD.scale()) : "Inconsistent scale of aggregate Decimal!";
                assert (mergeFieldDD.precision() == inFieldDD.precision()) : "Inconsistent precision of aggregate Decimal!";
                BigDecimal bigDecimal = mergeFieldDD.toBigDecimal();
                BigDecimal bigDecimal1 = inFieldDD.toBigDecimal();
                BigDecimal mul = bigDecimal.multiply(bigDecimal1);
                product = Decimal.fromBigDecimal(mul, mergeFieldDD.precision(), mergeFieldDD.scale());
                break;
            }
            case TINYINT: {
                product = (byte)((Byte)accumulator * (Byte)inputField);
                break;
            }
            case SMALLINT: {
                product = (short)((Short)accumulator * (Short)inputField);
                break;
            }
            case INTEGER: {
                product = (Integer)accumulator * (Integer)inputField;
                break;
            }
            case BIGINT: {
                product = (Long)accumulator * (Long)inputField;
                break;
            }
            case FLOAT: {
                product = Float.valueOf(((Float)accumulator).floatValue() * ((Float)inputField).floatValue());
                break;
            }
            case DOUBLE: {
                product = (Double)accumulator * (Double)inputField;
                break;
            }
            default: {
                String msg = String.format("type %s not support in %s", this.fieldType.getTypeRoot().toString(), this.getClass().getName());
                throw new IllegalArgumentException(msg);
            }
        }
        return product;
    }

    @Override
    public Object retract(Object accumulator, Object inputField) {
        Object product;
        if (accumulator == null || inputField == null) {
            product = accumulator == null ? inputField : accumulator;
        } else {
            switch (this.fieldType.getTypeRoot()) {
                case DECIMAL: {
                    Decimal mergeFieldDD = (Decimal)accumulator;
                    Decimal inFieldDD = (Decimal)inputField;
                    assert (mergeFieldDD.scale() == inFieldDD.scale()) : "Inconsistent scale of aggregate Decimal!";
                    assert (mergeFieldDD.precision() == inFieldDD.precision()) : "Inconsistent precision of aggregate Decimal!";
                    BigDecimal bigDecimal = mergeFieldDD.toBigDecimal();
                    BigDecimal bigDecimal1 = inFieldDD.toBigDecimal();
                    BigDecimal div = bigDecimal.divide(bigDecimal1);
                    product = Decimal.fromBigDecimal(div, mergeFieldDD.precision(), mergeFieldDD.scale());
                    break;
                }
                case TINYINT: {
                    product = (byte)((Byte)accumulator / (Byte)inputField);
                    break;
                }
                case SMALLINT: {
                    product = (short)((Short)accumulator / (Short)inputField);
                    break;
                }
                case INTEGER: {
                    product = (Integer)accumulator / (Integer)inputField;
                    break;
                }
                case BIGINT: {
                    product = (Long)accumulator / (Long)inputField;
                    break;
                }
                case FLOAT: {
                    product = Float.valueOf(((Float)accumulator).floatValue() / ((Float)inputField).floatValue());
                    break;
                }
                case DOUBLE: {
                    product = (Double)accumulator / (Double)inputField;
                    break;
                }
                default: {
                    String msg = String.format("type %s not support in %s", this.fieldType.getTypeRoot().toString(), this.getClass().getName());
                    throw new IllegalArgumentException(msg);
                }
            }
        }
        return product;
    }
}

