/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.paimon.Changelog;
import org.apache.paimon.Snapshot;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.consumer.ConsumerManager;
import org.apache.paimon.manifest.ExpireFileEntry;
import org.apache.paimon.operation.SnapshotDeletion;
import org.apache.paimon.options.ExpireConfig;
import org.apache.paimon.table.ExpireSnapshots;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpireSnapshotsImpl
implements ExpireSnapshots {
    private static final Logger LOG = LoggerFactory.getLogger(ExpireSnapshotsImpl.class);
    private final SnapshotManager snapshotManager;
    private final ConsumerManager consumerManager;
    private final SnapshotDeletion snapshotDeletion;
    private final TagManager tagManager;
    private ExpireConfig expireConfig;

    public ExpireSnapshotsImpl(SnapshotManager snapshotManager, SnapshotDeletion snapshotDeletion, TagManager tagManager) {
        this.snapshotManager = snapshotManager;
        this.consumerManager = new ConsumerManager(snapshotManager.fileIO(), snapshotManager.tablePath(), snapshotManager.branch());
        this.snapshotDeletion = snapshotDeletion;
        this.tagManager = tagManager;
        this.expireConfig = ExpireConfig.builder().build();
    }

    @Override
    public ExpireSnapshots config(ExpireConfig expireConfig) {
        this.expireConfig = expireConfig;
        return this;
    }

    @Override
    public int expire() {
        this.snapshotDeletion.setChangelogDecoupled(this.expireConfig.isChangelogDecoupled());
        int retainMax = this.expireConfig.getSnapshotRetainMax();
        int retainMin = this.expireConfig.getSnapshotRetainMin();
        int maxDeletes = this.expireConfig.getSnapshotMaxDeletes();
        long olderThanMills = System.currentTimeMillis() - this.expireConfig.getSnapshotTimeRetain().toMillis();
        Long latestSnapshotId = this.snapshotManager.latestSnapshotId();
        if (latestSnapshotId == null) {
            return 0;
        }
        Long earliest = this.snapshotManager.earliestSnapshotId();
        if (earliest == null) {
            return 0;
        }
        Preconditions.checkArgument(retainMax >= retainMin, "retainMax must greater than retainMin.");
        long min = Math.max(latestSnapshotId - (long)retainMax + 1L, earliest);
        long maxExclusive = latestSnapshotId - (long)retainMin + 1L;
        maxExclusive = Math.min(maxExclusive, this.consumerManager.minNextSnapshot().orElse(Long.MAX_VALUE));
        maxExclusive = Math.min(maxExclusive, earliest + (long)maxDeletes);
        for (long id = min; id < maxExclusive; ++id) {
            if (!this.snapshotManager.snapshotExists(id) || olderThanMills > this.snapshotManager.snapshot(id).timeMillis()) continue;
            return this.expireUntil(earliest, id);
        }
        return this.expireUntil(earliest, maxExclusive);
    }

    @VisibleForTesting
    public int expireUntil(long earliestId, long endExclusiveId) {
        HashSet<String> skippingSet;
        long beginInclusiveId;
        block24: {
            Snapshot snapshot;
            long id;
            if (endExclusiveId <= earliestId) {
                if (this.snapshotManager.readHint("EARLIEST") == null) {
                    this.writeEarliestHint(earliestId);
                }
                return 0;
            }
            beginInclusiveId = earliestId;
            for (long id2 = endExclusiveId - 1L; id2 >= earliestId; --id2) {
                if (this.snapshotManager.snapshotExists(id2)) continue;
                beginInclusiveId = id2 + 1L;
                break;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Snapshot expire range is [" + beginInclusiveId + ", " + endExclusiveId + ")");
            }
            List<Snapshot> taggedSnapshots = this.tagManager.taggedSnapshots();
            for (id = beginInclusiveId + 1L; id <= endExclusiveId; ++id) {
                Predicate<ExpireFileEntry> skipper;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ready to delete merge tree files not used by snapshot #" + id);
                }
                try {
                    snapshot = this.snapshotManager.tryGetSnapshot(id);
                }
                catch (FileNotFoundException e) {
                    beginInclusiveId = id + 1L;
                    continue;
                }
                try {
                    skipper = this.snapshotDeletion.createDataFileSkipperForTags(taggedSnapshots, id);
                }
                catch (Exception e) {
                    LOG.info(String.format("Skip cleaning data files of snapshot '%s' due to failed to build skipping set.", id), (Throwable)e);
                    continue;
                }
                this.snapshotDeletion.cleanUnusedDataFiles(snapshot, skipper);
            }
            if (!this.expireConfig.isChangelogDecoupled()) {
                for (id = beginInclusiveId; id < endExclusiveId; ++id) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Ready to delete changelog files from snapshot #" + id);
                    }
                    try {
                        snapshot = this.snapshotManager.tryGetSnapshot(id);
                    }
                    catch (FileNotFoundException e) {
                        beginInclusiveId = id + 1L;
                        continue;
                    }
                    if (snapshot.changelogManifestList() == null) continue;
                    this.snapshotDeletion.deleteAddedDataFiles(snapshot.changelogManifestList());
                }
            }
            this.snapshotDeletion.cleanEmptyDirectories();
            List<Snapshot> skippingSnapshots = ExpireSnapshotsImpl.findSkippingTags(taggedSnapshots, beginInclusiveId, endExclusiveId);
            try {
                skippingSnapshots.add(this.snapshotManager.tryGetSnapshot(endExclusiveId));
            }
            catch (FileNotFoundException e) {
                return 0;
            }
            skippingSet = new HashSet<String>();
            try {
                skippingSet.addAll(this.snapshotDeletion.manifestSkippingSet(skippingSnapshots));
            }
            catch (Exception e) {
                if (e.getCause() != null && e.getCause() instanceof FileNotFoundException) break block24;
                throw e;
            }
        }
        for (long id = beginInclusiveId; id < endExclusiveId; ++id) {
            Snapshot snapshot;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ready to delete manifests in snapshot #" + id);
            }
            try {
                snapshot = this.snapshotManager.tryGetSnapshot(id);
            }
            catch (FileNotFoundException e) {
                beginInclusiveId = id + 1L;
                continue;
            }
            this.snapshotDeletion.cleanUnusedManifests(snapshot, (Set<String>)skippingSet);
            if (this.expireConfig.isChangelogDecoupled()) {
                this.commitChangelog(new Changelog(snapshot));
            }
            this.snapshotManager.deleteSnapshot(id);
        }
        this.writeEarliestHint(endExclusiveId);
        return (int)(endExclusiveId - beginInclusiveId);
    }

    private void commitChangelog(Changelog changelog) {
        try {
            this.snapshotManager.commitChangelog(changelog, changelog.id());
            this.snapshotManager.commitLongLivedChangelogLatestHint(changelog.id());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeEarliestHint(long earliest) {
        try {
            this.snapshotManager.commitEarliestHint(earliest);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @VisibleForTesting
    public SnapshotDeletion snapshotDeletion() {
        return this.snapshotDeletion;
    }

    public static List<Snapshot> findSkippingTags(List<Snapshot> sortedTags, long beginInclusive, long endExclusive) {
        ArrayList<Snapshot> overlappedSnapshots = new ArrayList<Snapshot>();
        int right = SnapshotManager.findPreviousSnapshot(sortedTags, endExclusive);
        if (right >= 0) {
            int left;
            for (int i = left = Math.max(SnapshotManager.findPreviousOrEqualSnapshot(sortedTags, beginInclusive), 0); i <= right; ++i) {
                overlappedSnapshots.add(sortedTags.get(i));
            }
        }
        return overlappedSnapshots;
    }
}

