/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table;

import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import org.apache.paimon.Snapshot;
import org.apache.paimon.annotation.Experimental;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.stats.Statistics;
import org.apache.paimon.table.ExpireSnapshots;
import org.apache.paimon.table.sink.BatchWriteBuilder;
import org.apache.paimon.table.sink.StreamWriteBuilder;
import org.apache.paimon.table.source.ReadBuilder;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.SimpleFileReader;

@Public
public interface Table
extends Serializable {
    public String name();

    default public String fullName() {
        return this.name();
    }

    default public String uuid() {
        return this.fullName();
    }

    public RowType rowType();

    public List<String> partitionKeys();

    public List<String> primaryKeys();

    public Map<String, String> options();

    public Optional<String> comment();

    @Experimental
    public Optional<Statistics> statistics();

    public Table copy(Map<String, String> var1);

    @Experimental
    public OptionalLong latestSnapshotId();

    @Experimental
    public Snapshot snapshot(long var1);

    @Experimental
    public SimpleFileReader<ManifestFileMeta> manifestListReader();

    @Experimental
    public SimpleFileReader<ManifestEntry> manifestFileReader();

    @Experimental
    public SimpleFileReader<IndexManifestEntry> indexManifestFileReader();

    @Experimental
    public void rollbackTo(long var1);

    @Experimental
    public void createTag(String var1, long var2);

    @Experimental
    public void createTag(String var1, long var2, Duration var4);

    @Experimental
    public void createTag(String var1);

    @Experimental
    public void createTag(String var1, Duration var2);

    @Experimental
    public void renameTag(String var1, String var2);

    @Experimental
    public void replaceTag(String var1, Long var2, Duration var3);

    @Experimental
    public void deleteTag(String var1);

    @Experimental
    default public void deleteTags(String tagStr) {
        String[] tagNames;
        for (String tagName : tagNames = (String[])Arrays.stream(tagStr.split(",")).map(String::trim).toArray(String[]::new)) {
            this.deleteTag(tagName);
        }
    }

    @Experimental
    public void rollbackTo(String var1);

    @Experimental
    public void createBranch(String var1);

    @Experimental
    public void createBranch(String var1, String var2);

    @Experimental
    public void deleteBranch(String var1);

    @Experimental
    default public void deleteBranches(String branchNames) {
        for (String branch : branchNames.split(",")) {
            this.deleteBranch(branch);
        }
    }

    @Experimental
    public void fastForward(String var1);

    @Experimental
    public ExpireSnapshots newExpireSnapshots();

    @Experimental
    public ExpireSnapshots newExpireChangelog();

    public ReadBuilder newReadBuilder();

    public BatchWriteBuilder newBatchWriteBuilder();

    public StreamWriteBuilder newStreamWriteBuilder();
}

