/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.GenericArray;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.factories.FactoryException;
import org.apache.paimon.factories.FactoryUtil;
import org.apache.paimon.fs.Path;
import org.apache.paimon.iceberg.IcebergMetadataCommitter;
import org.apache.paimon.iceberg.IcebergMetadataCommitterFactory;
import org.apache.paimon.iceberg.IcebergOptions;
import org.apache.paimon.iceberg.IcebergPathFactory;
import org.apache.paimon.iceberg.manifest.IcebergConversions;
import org.apache.paimon.iceberg.manifest.IcebergDataFileMeta;
import org.apache.paimon.iceberg.manifest.IcebergManifestEntry;
import org.apache.paimon.iceberg.manifest.IcebergManifestFile;
import org.apache.paimon.iceberg.manifest.IcebergManifestFileMeta;
import org.apache.paimon.iceberg.manifest.IcebergManifestList;
import org.apache.paimon.iceberg.manifest.IcebergPartitionSummary;
import org.apache.paimon.iceberg.metadata.IcebergDataField;
import org.apache.paimon.iceberg.metadata.IcebergMetadata;
import org.apache.paimon.iceberg.metadata.IcebergPartitionField;
import org.apache.paimon.iceberg.metadata.IcebergPartitionSpec;
import org.apache.paimon.iceberg.metadata.IcebergSchema;
import org.apache.paimon.iceberg.metadata.IcebergSnapshot;
import org.apache.paimon.iceberg.metadata.IcebergSnapshotSummary;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.manifest.ManifestCommittable;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.options.Options;
import org.apache.paimon.partition.PartitionPredicate;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.CommitCallback;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.RawFile;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.DataFilePathFactories;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.ManifestReadThreadPool;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.SnapshotManager;

public class IcebergCommitCallback
implements CommitCallback {
    private static final String VERSION_HINT_FILENAME = "version-hint.text";
    private final FileStoreTable table;
    private final String commitUser;
    private final IcebergPathFactory pathFactory;
    @Nullable
    private final IcebergMetadataCommitter metadataCommitter;
    private final FileStorePathFactory fileStorePathFactory;
    private final IcebergManifestFile manifestFile;
    private final IcebergManifestList manifestList;

    public IcebergCommitCallback(FileStoreTable table, String commitUser) {
        IcebergMetadataCommitterFactory metadataCommitterFactory;
        this.table = table;
        this.commitUser = commitUser;
        IcebergOptions.StorageType storageType = table.coreOptions().toConfiguration().get(IcebergOptions.METADATA_ICEBERG_STORAGE);
        switch (storageType) {
            case TABLE_LOCATION: {
                this.pathFactory = new IcebergPathFactory(new Path(table.location(), "metadata"));
                break;
            }
            case HADOOP_CATALOG: 
            case HIVE_CATALOG: {
                this.pathFactory = new IcebergPathFactory(IcebergCommitCallback.catalogTableMetadataPath(table));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown storage type " + storageType.name());
            }
        }
        try {
            metadataCommitterFactory = FactoryUtil.discoverFactory(IcebergCommitCallback.class.getClassLoader(), IcebergMetadataCommitterFactory.class, storageType.toString());
        }
        catch (FactoryException ignore) {
            metadataCommitterFactory = null;
        }
        this.metadataCommitter = metadataCommitterFactory == null ? null : metadataCommitterFactory.create(table);
        this.fileStorePathFactory = table.store().pathFactory();
        this.manifestFile = IcebergManifestFile.create(table, this.pathFactory);
        this.manifestList = IcebergManifestList.create(table, this.pathFactory);
    }

    public static Path catalogTableMetadataPath(FileStoreTable table) {
        Path icebergDBPath = IcebergCommitCallback.catalogDatabasePath(table);
        return new Path(icebergDBPath, String.format("%s/metadata", table.location().getName()));
    }

    public static Path catalogDatabasePath(FileStoreTable table) {
        Path dbPath = table.location().getParent();
        String dbSuffix = ".db";
        if (dbPath.getName().endsWith(".db")) {
            String dbName = dbPath.getName().substring(0, dbPath.getName().length() - ".db".length());
            return new Path(dbPath.getParent(), String.format("iceberg/%s/", dbName));
        }
        throw new UnsupportedOperationException("Storage type ICEBERG_WAREHOUSE can only be used on Paimon tables in a Paimon warehouse.");
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void call(List<ManifestEntry> committedEntries, Snapshot snapshot) {
        this.createMetadata(snapshot.id(), (removedFiles, addedFiles) -> this.collectFileChanges(committedEntries, (Map<String, BinaryRow>)removedFiles, (Map<String, Pair<BinaryRow, DataFileMeta>>)addedFiles));
    }

    @Override
    public void retry(ManifestCommittable committable) {
        SnapshotManager snapshotManager = this.table.snapshotManager();
        long snapshotId = snapshotManager.findSnapshotsForIdentifiers(this.commitUser, Collections.singletonList(committable.identifier())).stream().mapToLong(Snapshot::id).max().orElseThrow(() -> new RuntimeException("There is no snapshot for commit user " + this.commitUser + " and identifier " + committable.identifier() + ". This is unexpected."));
        this.createMetadata(snapshotId, (removedFiles, addedFiles) -> this.collectFileChanges(snapshotId, (Map<String, BinaryRow>)removedFiles, (Map<String, Pair<BinaryRow, DataFileMeta>>)addedFiles));
    }

    private void createMetadata(long snapshotId, FileChangesCollector fileChangesCollector) {
        try {
            if (snapshotId == 1L) {
                this.table.fileIO().delete(this.pathFactory.metadataDirectory(), true);
            }
            if (this.table.fileIO().exists(this.pathFactory.toMetadataPath(snapshotId))) {
                return;
            }
            Path baseMetadataPath = this.pathFactory.toMetadataPath(snapshotId - 1L);
            if (this.table.fileIO().exists(baseMetadataPath)) {
                this.createMetadataWithBase(fileChangesCollector, snapshotId, baseMetadataPath);
            } else {
                this.createMetadataWithoutBase(snapshotId);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void createMetadataWithoutBase(long snapshotId) throws IOException {
        SnapshotReader snapshotReader = this.table.newSnapshotReader().withSnapshot(snapshotId);
        SchemaCache schemaCache = new SchemaCache();
        Iterator<IcebergManifestEntry> entryIterator = snapshotReader.read().dataSplits().stream().filter(DataSplit::rawConvertible).flatMap(s -> this.dataSplitToManifestEntries((DataSplit)s, snapshotId, schemaCache).stream()).iterator();
        List<IcebergManifestFileMeta> manifestFileMetas = this.manifestFile.rollingWrite(entryIterator, snapshotId);
        String manifestListFileName = this.manifestList.writeWithoutRolling(manifestFileMetas);
        int schemaId = (int)this.table.schema().id();
        IcebergSchema icebergSchema = schemaCache.get(schemaId);
        List<IcebergPartitionField> partitionFields = this.getPartitionFields(this.table.schema().partitionKeys(), icebergSchema);
        IcebergSnapshot snapshot = new IcebergSnapshot(snapshotId, snapshotId, System.currentTimeMillis(), IcebergSnapshotSummary.APPEND, this.pathFactory.toManifestListPath(manifestListFileName).toString(), schemaId);
        String tableUuid = UUID.randomUUID().toString();
        IcebergMetadata metadata = new IcebergMetadata(tableUuid, this.table.location().toString(), snapshotId, icebergSchema.highestFieldId(), Collections.singletonList(icebergSchema), schemaId, Collections.singletonList(new IcebergPartitionSpec(partitionFields)), partitionFields.stream().mapToInt(IcebergPartitionField::fieldId).max().orElse(999), Collections.singletonList(snapshot), (int)snapshotId);
        Path metadataPath = this.pathFactory.toMetadataPath(snapshotId);
        this.table.fileIO().tryToWriteAtomic(metadataPath, metadata.toJson());
        this.table.fileIO().overwriteFileUtf8(new Path(this.pathFactory.metadataDirectory(), VERSION_HINT_FILENAME), String.valueOf(snapshotId));
        this.expireAllBefore(snapshotId);
        if (this.metadataCommitter != null) {
            this.metadataCommitter.commitMetadata(metadataPath, null);
        }
    }

    private List<IcebergManifestEntry> dataSplitToManifestEntries(DataSplit dataSplit, long snapshotId, SchemaCache schemaCache) {
        ArrayList<IcebergManifestEntry> result = new ArrayList<IcebergManifestEntry>();
        List<RawFile> rawFiles = dataSplit.convertToRawFiles().get();
        for (int i = 0; i < dataSplit.dataFiles().size(); ++i) {
            DataFileMeta paimonFileMeta = dataSplit.dataFiles().get(i);
            RawFile rawFile = rawFiles.get(i);
            IcebergDataFileMeta fileMeta = IcebergDataFileMeta.create(IcebergDataFileMeta.Content.DATA, rawFile.path(), rawFile.format(), dataSplit.partition(), rawFile.rowCount(), rawFile.fileSize(), schemaCache.get(paimonFileMeta.schemaId()), paimonFileMeta.valueStats(), paimonFileMeta.valueStatsCols());
            result.add(new IcebergManifestEntry(IcebergManifestEntry.Status.ADDED, snapshotId, snapshotId, snapshotId, fileMeta));
        }
        return result;
    }

    private List<IcebergPartitionField> getPartitionFields(List<String> partitionKeys, IcebergSchema icebergSchema) {
        HashMap<String, IcebergDataField> fields = new HashMap<String, IcebergDataField>();
        for (IcebergDataField field : icebergSchema.fields()) {
            fields.put(field.name(), field);
        }
        ArrayList<IcebergPartitionField> result = new ArrayList<IcebergPartitionField>();
        int fieldId = 1000;
        for (String partitionKey : partitionKeys) {
            result.add(new IcebergPartitionField((IcebergDataField)fields.get(partitionKey), fieldId));
            ++fieldId;
        }
        return result;
    }

    private void createMetadataWithBase(FileChangesCollector fileChangesCollector, long snapshotId, Path baseMetadataPath) throws IOException {
        IcebergSnapshotSummary snapshotSummary;
        ArrayList<IcebergManifestFileMeta> newManifestFileMetas;
        IcebergMetadata baseMetadata = IcebergMetadata.fromPath(this.table.fileIO(), baseMetadataPath);
        List<IcebergManifestFileMeta> baseManifestFileMetas = this.manifestList.read(baseMetadata.currentSnapshot().manifestList());
        LinkedHashMap<String, BinaryRow> removedFiles = new LinkedHashMap<String, BinaryRow>();
        LinkedHashMap<String, Pair<BinaryRow, DataFileMeta>> addedFiles = new LinkedHashMap<String, Pair<BinaryRow, DataFileMeta>>();
        boolean isAddOnly = fileChangesCollector.collect(removedFiles, addedFiles);
        LinkedHashSet modifiedPartitionsSet = new LinkedHashSet(removedFiles.values());
        modifiedPartitionsSet.addAll(addedFiles.values().stream().map(Pair::getLeft).collect(Collectors.toList()));
        ArrayList<BinaryRow> modifiedPartitions = new ArrayList<BinaryRow>(modifiedPartitionsSet);
        if (isAddOnly) {
            newManifestFileMetas = new ArrayList(baseManifestFileMetas);
            newManifestFileMetas.addAll(this.createNewlyAddedManifestFileMetas(addedFiles, snapshotId));
            snapshotSummary = IcebergSnapshotSummary.APPEND;
        } else {
            Pair<List<IcebergManifestFileMeta>, IcebergSnapshotSummary> result = this.createWithDeleteManifestFileMetas(removedFiles, addedFiles, modifiedPartitions, baseManifestFileMetas, snapshotId);
            newManifestFileMetas = result.getLeft();
            snapshotSummary = result.getRight();
        }
        String manifestListFileName = this.manifestList.writeWithoutRolling(this.compactMetadataIfNeeded(newManifestFileMetas, snapshotId));
        SchemaCache schemaCache = new SchemaCache();
        int schemaId = (int)this.table.schema().id();
        IcebergSchema icebergSchema = schemaCache.get(schemaId);
        List<IcebergSchema> schemas = baseMetadata.schemas();
        if (baseMetadata.currentSchemaId() != schemaId) {
            schemas = new ArrayList<IcebergSchema>(schemas);
            schemas.add(icebergSchema);
        }
        List<IcebergSnapshot> snapshots2 = new ArrayList<IcebergSnapshot>(baseMetadata.snapshots());
        snapshots2.add(new IcebergSnapshot(snapshotId, snapshotId, System.currentTimeMillis(), snapshotSummary, this.pathFactory.toManifestListPath(manifestListFileName).toString(), schemaId));
        ArrayList toExpireExceptLast = new ArrayList();
        int i = 0;
        while (i + 1 < snapshots2.size()) {
            toExpireExceptLast.add(snapshots2.get(i));
            if (!this.shouldExpire((IcebergSnapshot)snapshots2.get(i), snapshotId)) {
                snapshots2 = snapshots2.subList(i, snapshots2.size());
                break;
            }
            ++i;
        }
        IcebergMetadata metadata = new IcebergMetadata(baseMetadata.tableUuid(), baseMetadata.location(), snapshotId, icebergSchema.highestFieldId(), schemas, schemaId, baseMetadata.partitionSpecs(), baseMetadata.lastPartitionId(), snapshots2, (int)snapshotId);
        Path metadataPath = this.pathFactory.toMetadataPath(snapshotId);
        this.table.fileIO().tryToWriteAtomic(metadataPath, metadata.toJson());
        this.table.fileIO().overwriteFileUtf8(new Path(this.pathFactory.metadataDirectory(), VERSION_HINT_FILENAME), String.valueOf(snapshotId));
        this.deleteApplicableMetadataFiles(snapshotId);
        int i2 = 0;
        while (i2 + 1 < toExpireExceptLast.size()) {
            this.expireManifestList(new Path(((IcebergSnapshot)toExpireExceptLast.get(i2)).manifestList()).getName(), new Path(((IcebergSnapshot)toExpireExceptLast.get(i2 + 1)).manifestList()).getName());
            ++i2;
        }
        if (this.metadataCommitter != null) {
            this.metadataCommitter.commitMetadata(metadataPath, baseMetadataPath);
        }
    }

    private boolean collectFileChanges(List<ManifestEntry> manifestEntries, Map<String, BinaryRow> removedFiles, Map<String, Pair<BinaryRow, DataFileMeta>> addedFiles) {
        boolean isAddOnly = true;
        DataFilePathFactories factories = new DataFilePathFactories(this.fileStorePathFactory);
        block4: for (ManifestEntry entry : manifestEntries) {
            DataFilePathFactory dataFilePathFactory = factories.get(entry.partition(), entry.bucket());
            String path = dataFilePathFactory.toPath(entry).toString();
            switch (entry.kind()) {
                case ADD: {
                    if (!this.shouldAddFileToIceberg(entry.file())) continue block4;
                    removedFiles.remove(path);
                    addedFiles.put(path, Pair.of(entry.partition(), entry.file()));
                    continue block4;
                }
                case DELETE: {
                    isAddOnly = false;
                    addedFiles.remove(path);
                    removedFiles.put(path, entry.partition());
                    continue block4;
                }
            }
            throw new UnsupportedOperationException("Unknown ManifestEntry FileKind " + (Object)((Object)entry.kind()));
        }
        return isAddOnly;
    }

    private boolean collectFileChanges(long snapshotId, Map<String, BinaryRow> removedFiles, Map<String, Pair<BinaryRow, DataFileMeta>> addedFiles) {
        return this.collectFileChanges(this.table.store().newScan().withKind(ScanMode.DELTA).withSnapshot(snapshotId).plan().files(), removedFiles, addedFiles);
    }

    private boolean shouldAddFileToIceberg(DataFileMeta meta) {
        if (this.table.primaryKeys().isEmpty()) {
            return true;
        }
        int maxLevel = this.table.coreOptions().numLevels() - 1;
        return meta.level() == maxLevel;
    }

    private List<IcebergManifestFileMeta> createNewlyAddedManifestFileMetas(Map<String, Pair<BinaryRow, DataFileMeta>> addedFiles, long currentSnapshotId) throws IOException {
        if (addedFiles.isEmpty()) {
            return Collections.emptyList();
        }
        SchemaCache schemaCache = new SchemaCache();
        return this.manifestFile.rollingWrite(addedFiles.entrySet().stream().map(e -> {
            DataFileMeta paimonFileMeta = (DataFileMeta)((Pair)e.getValue()).getRight();
            IcebergDataFileMeta icebergFileMeta = IcebergDataFileMeta.create(IcebergDataFileMeta.Content.DATA, (String)e.getKey(), paimonFileMeta.fileFormat(), (BinaryRow)((Pair)e.getValue()).getLeft(), paimonFileMeta.rowCount(), paimonFileMeta.fileSize(), schemaCache.get(paimonFileMeta.schemaId()), paimonFileMeta.valueStats(), paimonFileMeta.valueStatsCols());
            return new IcebergManifestEntry(IcebergManifestEntry.Status.ADDED, currentSnapshotId, currentSnapshotId, currentSnapshotId, icebergFileMeta);
        }).iterator(), currentSnapshotId);
    }

    private Pair<List<IcebergManifestFileMeta>, IcebergSnapshotSummary> createWithDeleteManifestFileMetas(Map<String, BinaryRow> removedFiles, Map<String, Pair<BinaryRow, DataFileMeta>> addedFiles, List<BinaryRow> modifiedPartitions, List<IcebergManifestFileMeta> baseManifestFileMetas, long currentSnapshotId) throws IOException {
        IcebergSnapshotSummary snapshotSummary = IcebergSnapshotSummary.APPEND;
        ArrayList<IcebergManifestFileMeta> newManifestFileMetas = new ArrayList<IcebergManifestFileMeta>();
        RowType partitionType = this.table.schema().logicalPartitionType();
        PartitionPredicate predicate = PartitionPredicate.fromMultiple(partitionType, modifiedPartitions);
        for (IcebergManifestFileMeta fileMeta : baseManifestFileMetas) {
            int numFields = partitionType.getFieldCount();
            GenericRow minValues = new GenericRow(numFields);
            GenericRow maxValues = new GenericRow(numFields);
            long[] nullCounts = new long[numFields];
            for (int i = 0; i < numFields; ++i) {
                IcebergPartitionSummary summary = fileMeta.partitions().get(i);
                DataType fieldType = partitionType.getTypeAt(i);
                minValues.setField(i, IcebergConversions.toPaimonObject(fieldType, summary.lowerBound()));
                maxValues.setField(i, IcebergConversions.toPaimonObject(fieldType, summary.upperBound()));
                nullCounts[i] = summary.containsNull() ? 1L : 0L;
            }
            if (predicate == null || predicate.test(fileMeta.liveRowsCount(), minValues, maxValues, new GenericArray(nullCounts))) {
                List entries = this.manifestFile.read(new Path(fileMeta.manifestPath()).getName());
                boolean canReuseFile = true;
                for (IcebergManifestEntry entry : entries) {
                    if (!entry.isLive()) continue;
                    String path = entry.file().filePath();
                    if (addedFiles.containsKey(path)) {
                        addedFiles.remove(path);
                        continue;
                    }
                    if (!removedFiles.containsKey(path)) continue;
                    canReuseFile = false;
                }
                if (canReuseFile) {
                    newManifestFileMetas.add(fileMeta);
                    continue;
                }
                snapshotSummary = IcebergSnapshotSummary.OVERWRITE;
                ArrayList<IcebergManifestEntry> newEntries = new ArrayList<IcebergManifestEntry>();
                for (IcebergManifestEntry entry : entries) {
                    if (!entry.isLive()) continue;
                    newEntries.add(new IcebergManifestEntry(removedFiles.containsKey(entry.file().filePath()) ? IcebergManifestEntry.Status.DELETED : IcebergManifestEntry.Status.EXISTING, entry.snapshotId(), entry.sequenceNumber(), entry.fileSequenceNumber(), entry.file()));
                }
                newManifestFileMetas.addAll(this.manifestFile.rollingWrite(newEntries.iterator(), currentSnapshotId));
                continue;
            }
            newManifestFileMetas.add(fileMeta);
        }
        newManifestFileMetas.addAll(this.createNewlyAddedManifestFileMetas(addedFiles, currentSnapshotId));
        return Pair.of(newManifestFileMetas, snapshotSummary);
    }

    private List<IcebergManifestFileMeta> compactMetadataIfNeeded(List<IcebergManifestFileMeta> toCompact, long currentSnapshotId) throws IOException {
        ArrayList<IcebergManifestFileMeta> result = new ArrayList<IcebergManifestFileMeta>();
        long targetSizeInBytes = this.table.coreOptions().manifestTargetSize().getBytes();
        ArrayList<IcebergManifestFileMeta> candidates = new ArrayList<IcebergManifestFileMeta>();
        long totalSizeInBytes = 0L;
        for (IcebergManifestFileMeta meta2 : toCompact) {
            if (meta2.manifestLength() < targetSizeInBytes * 2L / 3L) {
                candidates.add(meta2);
                totalSizeInBytes += meta2.manifestLength();
                continue;
            }
            result.add(meta2);
        }
        Options options = new Options(this.table.options());
        if (candidates.size() < options.get(IcebergOptions.COMPACT_MIN_FILE_NUM)) {
            return toCompact;
        }
        if (candidates.size() < options.get(IcebergOptions.COMPACT_MAX_FILE_NUM) && totalSizeInBytes < targetSizeInBytes) {
            return toCompact;
        }
        Function<IcebergManifestFileMeta, List> processor = meta -> {
            ArrayList<IcebergManifestEntry> entries = new ArrayList<IcebergManifestEntry>();
            for (IcebergManifestEntry entry : IcebergManifestFile.create(this.table, this.pathFactory).read(new Path(meta.manifestPath()).getName())) {
                if (entry.fileSequenceNumber() == currentSnapshotId || entry.status() == IcebergManifestEntry.Status.EXISTING) {
                    entries.add(entry);
                    continue;
                }
                if (entry.status() != IcebergManifestEntry.Status.ADDED) {
                    if (entry.status() == IcebergManifestEntry.Status.DELETED) continue;
                    throw new UnsupportedOperationException("Unknown IcebergManifestEntry.Status " + (Object)((Object)entry.status()));
                }
                IcebergManifestEntry.Status newStatus = IcebergManifestEntry.Status.EXISTING;
                entries.add(new IcebergManifestEntry(newStatus, entry.snapshotId(), entry.sequenceNumber(), entry.fileSequenceNumber(), entry.file()));
            }
            if (meta.sequenceNumber() == currentSnapshotId) {
                this.table.fileIO().deleteQuietly(new Path(meta.manifestPath()));
            }
            return entries;
        };
        Iterable newEntries = ManifestReadThreadPool.sequentialBatchedExecute(processor, candidates, null);
        result.addAll(this.manifestFile.rollingWrite(newEntries.iterator(), currentSnapshotId));
        return result;
    }

    private boolean shouldExpire(IcebergSnapshot snapshot, long currentSnapshotId) {
        Options options = new Options(this.table.options());
        if (snapshot.snapshotId() > currentSnapshotId - (long)options.get(CoreOptions.SNAPSHOT_NUM_RETAINED_MIN).intValue()) {
            return false;
        }
        if (snapshot.snapshotId() <= currentSnapshotId - (long)options.get(CoreOptions.SNAPSHOT_NUM_RETAINED_MAX).intValue()) {
            return true;
        }
        return snapshot.timestampMs() < System.currentTimeMillis() - options.get(CoreOptions.SNAPSHOT_TIME_RETAINED).toMillis();
    }

    private void expireManifestList(String toExpire, String next) {
        HashSet metaInUse = new HashSet(this.manifestList.read(next));
        for (IcebergManifestFileMeta meta : this.manifestList.read(toExpire)) {
            if (metaInUse.contains(meta)) continue;
            this.table.fileIO().deleteQuietly(new Path(meta.manifestPath()));
        }
        this.table.fileIO().deleteQuietly(this.pathFactory.toManifestListPath(toExpire));
    }

    private void expireAllBefore(long snapshotId) throws IOException {
        HashSet<String> expiredManifestLists = new HashSet<String>();
        HashSet<String> expiredManifestFileMetas = new HashSet<String>();
        Iterator it = this.pathFactory.getAllMetadataPathBefore(this.table.fileIO(), snapshotId).iterator();
        while (it.hasNext()) {
            Path path = (Path)it.next();
            IcebergMetadata metadata = IcebergMetadata.fromPath(this.table.fileIO(), path);
            for (IcebergSnapshot snapshot : metadata.snapshots()) {
                Path listPath = new Path(snapshot.manifestList());
                String listName = listPath.getName();
                if (expiredManifestLists.contains(listName)) continue;
                expiredManifestLists.add(listName);
                for (IcebergManifestFileMeta meta : this.manifestList.read(listName)) {
                    String metaName = new Path(meta.manifestPath()).getName();
                    if (expiredManifestFileMetas.contains(metaName)) continue;
                    expiredManifestFileMetas.add(metaName);
                    this.table.fileIO().deleteQuietly(new Path(meta.manifestPath()));
                }
                this.table.fileIO().deleteQuietly(listPath);
            }
            this.deleteApplicableMetadataFiles(snapshotId);
        }
    }

    private void deleteApplicableMetadataFiles(long snapshotId) throws IOException {
        long earliestMetadataId;
        Options options = new Options(this.table.options());
        if (options.get(IcebergOptions.METADATA_DELETE_AFTER_COMMIT).booleanValue() && (earliestMetadataId = snapshotId - (long)options.get(IcebergOptions.METADATA_PREVIOUS_VERSIONS_MAX).intValue()) > 0L) {
            Iterator it = this.pathFactory.getAllMetadataPathBefore(this.table.fileIO(), earliestMetadataId).iterator();
            while (it.hasNext()) {
                Path path = (Path)it.next();
                this.table.fileIO().deleteQuietly(path);
            }
        }
    }

    private class SchemaCache {
        SchemaManager schemaManager;
        Map<Long, IcebergSchema> schemas;

        private SchemaCache() {
            this.schemaManager = new SchemaManager(IcebergCommitCallback.this.table.fileIO(), IcebergCommitCallback.this.table.location());
            this.schemas = new HashMap<Long, IcebergSchema>();
        }

        private IcebergSchema get(long schemaId) {
            return this.schemas.computeIfAbsent(schemaId, id -> IcebergSchema.create(this.schemaManager.schema((long)id)));
        }
    }

    private static interface FileChangesCollector {
        public boolean collect(Map<String, BinaryRow> var1, Map<String, Pair<BinaryRow, DataFileMeta>> var2) throws IOException;
    }
}

