/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.index;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.paimon.Snapshot;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.index.BucketAssigner;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.index.PartitionIndex;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashBucketAssigner
implements BucketAssigner {
    private static final Logger LOG = LoggerFactory.getLogger(HashBucketAssigner.class);
    private final SnapshotManager snapshotManager;
    private final String commitUser;
    private final IndexFileHandler indexFileHandler;
    private final int numChannels;
    private final int numAssigners;
    private final int assignId;
    private final long targetBucketRowNumber;
    private final int maxBucketsNum;
    private int maxBucketId;
    private final Map<BinaryRow, PartitionIndex> partitionIndex;

    public HashBucketAssigner(SnapshotManager snapshotManager, String commitUser, IndexFileHandler indexFileHandler, int numChannels, int numAssigners, int assignId, long targetBucketRowNumber, int maxBucketsNum) {
        this.snapshotManager = snapshotManager;
        this.commitUser = commitUser;
        this.indexFileHandler = indexFileHandler;
        this.numChannels = numChannels;
        this.numAssigners = numAssigners;
        this.assignId = assignId;
        this.targetBucketRowNumber = targetBucketRowNumber;
        this.partitionIndex = new HashMap<BinaryRow, PartitionIndex>();
        this.maxBucketsNum = maxBucketsNum;
    }

    @Override
    public int assign(BinaryRow partition, int hash) {
        int partitionHash = partition.hashCode();
        int recordAssignId = this.computeAssignId(partitionHash, hash);
        Preconditions.checkArgument(recordAssignId == this.assignId, "This is a bug, record assign id %s should equal to assign id %s.", recordAssignId, this.assignId);
        PartitionIndex index = this.partitionIndex.get(partition);
        if (index == null) {
            partition = partition.copy();
            index = this.loadIndex(partition, partitionHash);
            this.partitionIndex.put(partition, index);
        }
        int assigned = index.assign(hash, this::isMyBucket, this.maxBucketsNum, this.maxBucketId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Assign {} to the partition {} key hash {}", new Object[]{assigned, partition, hash});
        }
        if (assigned > this.maxBucketId) {
            this.maxBucketId = assigned;
        }
        return assigned;
    }

    @Override
    public void prepareCommit(long commitIdentifier) {
        long latestCommittedIdentifier = this.partitionIndex.values().stream().mapToLong(i -> i.lastAccessedCommitIdentifier).max().orElse(Long.MIN_VALUE) == Long.MIN_VALUE ? Long.MIN_VALUE : this.snapshotManager.latestSnapshotOfUser(this.commitUser).map(Snapshot::commitIdentifier).orElse(Long.MIN_VALUE);
        Iterator<Map.Entry<BinaryRow, PartitionIndex>> iterator2 = this.partitionIndex.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<BinaryRow, PartitionIndex> entry = iterator2.next();
            BinaryRow partition = entry.getKey();
            PartitionIndex index = entry.getValue();
            if (index.accessed) {
                index.lastAccessedCommitIdentifier = commitIdentifier;
            } else if (index.lastAccessedCommitIdentifier <= latestCommittedIdentifier) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Removing index for partition {}. Index's last accessed identifier is {}, while latest committed identifier is {}, current commit identifier is {}.", new Object[]{partition, index.lastAccessedCommitIdentifier, latestCommittedIdentifier, commitIdentifier});
                }
                iterator2.remove();
            }
            index.accessed = false;
        }
    }

    @VisibleForTesting
    Set<BinaryRow> currentPartitions() {
        return this.partitionIndex.keySet();
    }

    private int computeAssignId(int partitionHash, int keyHash) {
        return BucketAssigner.computeAssigner(partitionHash, keyHash, this.numChannels, this.numAssigners);
    }

    private boolean isMyBucket(int bucket) {
        return BucketAssigner.isMyBucket(bucket, this.numAssigners, this.assignId);
    }

    private PartitionIndex loadIndex(BinaryRow partition, int partitionHash) {
        return PartitionIndex.loadIndex(this.indexFileHandler, partition, this.targetBucketRowNumber, hash -> this.computeAssignId(partitionHash, hash) == this.assignId, this::isMyBucket);
    }
}

