/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.KeyValueSerializer;
import org.apache.paimon.KeyValueThinSerializer;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.fileindex.FileIndexOptions;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.format.SimpleStatsCollector;
import org.apache.paimon.format.SimpleStatsExtractor;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.io.FileWriterContext;
import org.apache.paimon.io.KeyValueDataFileWriter;
import org.apache.paimon.io.KeyValueDataFileWriterImpl;
import org.apache.paimon.io.KeyValueThinDataFileWriterImpl;
import org.apache.paimon.io.RollingFileWriter;
import org.apache.paimon.io.SimpleStatsProducer;
import org.apache.paimon.manifest.FileSource;
import org.apache.paimon.statistics.NoneSimpleColStatsCollector;
import org.apache.paimon.statistics.SimpleColStatsCollector;
import org.apache.paimon.table.SpecialFields;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.StatsCollectorFactories;

public class KeyValueFileWriterFactory {
    private final FileIO fileIO;
    private final long schemaId;
    private final RowType keyType;
    private final RowType valueType;
    private final FileWriterContextFactory formatContext;
    private final long suggestedFileSize;
    private final CoreOptions options;
    private final FileIndexOptions fileIndexOptions;

    private KeyValueFileWriterFactory(FileIO fileIO, long schemaId, FileWriterContextFactory formatContext, long suggestedFileSize, CoreOptions options) {
        this.fileIO = fileIO;
        this.schemaId = schemaId;
        this.keyType = formatContext.keyType;
        this.valueType = formatContext.valueType;
        this.formatContext = formatContext;
        this.suggestedFileSize = suggestedFileSize;
        this.options = options;
        this.fileIndexOptions = options.indexColumnsOptions();
    }

    public RowType keyType() {
        return this.keyType;
    }

    public RowType valueType() {
        return this.valueType;
    }

    @VisibleForTesting
    public DataFilePathFactory pathFactory(int level) {
        return this.formatContext.pathFactory(new WriteFormatKey(level, false));
    }

    public RollingFileWriter<KeyValue, DataFileMeta> createRollingMergeTreeFileWriter(int level, FileSource fileSource) {
        WriteFormatKey key = new WriteFormatKey(level, false);
        return new RollingFileWriter<KeyValue, DataFileMeta>(() -> {
            DataFilePathFactory pathFactory = this.formatContext.pathFactory(key);
            return this.createDataFileWriter(pathFactory.newPath(), key, fileSource, pathFactory.isExternalPath());
        }, this.suggestedFileSize);
    }

    public RollingFileWriter<KeyValue, DataFileMeta> createRollingChangelogFileWriter(int level) {
        WriteFormatKey key = new WriteFormatKey(level, true);
        return new RollingFileWriter<KeyValue, DataFileMeta>(() -> {
            DataFilePathFactory pathFactory = this.formatContext.pathFactory(key);
            return this.createDataFileWriter(pathFactory.newChangelogPath(), key, FileSource.APPEND, pathFactory.isExternalPath());
        }, this.suggestedFileSize);
    }

    private KeyValueDataFileWriter createDataFileWriter(Path path, WriteFormatKey key, FileSource fileSource, boolean isExternalPath) {
        return this.formatContext.thinModeEnabled ? new KeyValueThinDataFileWriterImpl(this.fileIO, this.formatContext.fileWriterContext(key), path, new KeyValueThinSerializer(this.keyType, this.valueType)::toRow, this.keyType, this.valueType, this.schemaId, key.level, this.options, fileSource, this.fileIndexOptions, isExternalPath) : new KeyValueDataFileWriterImpl(this.fileIO, this.formatContext.fileWriterContext(key), path, new KeyValueSerializer(this.keyType, this.valueType)::toRow, this.keyType, this.valueType, this.schemaId, key.level, this.options, fileSource, this.fileIndexOptions, isExternalPath);
    }

    public void deleteFile(DataFileMeta file) {
        this.fileIO.deleteQuietly(this.formatContext.pathFactory(new WriteFormatKey(file.level(), false)).toPath(file));
    }

    public void copyFile(DataFileMeta sourceFile, DataFileMeta targetFile) throws IOException {
        boolean isChangelog = false;
        Path sourcePath = this.formatContext.pathFactory(new WriteFormatKey(sourceFile.level(), isChangelog)).toPath(sourceFile);
        Path targetPath = this.formatContext.pathFactory(new WriteFormatKey(targetFile.level(), isChangelog)).toPath(targetFile);
        this.fileIO.copyFile(sourcePath, targetPath, true);
    }

    public FileIO getFileIO() {
        return this.fileIO;
    }

    public String newChangelogFileName(int level) {
        return this.formatContext.pathFactory(new WriteFormatKey(level, true)).newChangelogFileName();
    }

    public static Builder builder(FileIO fileIO, long schemaId, RowType keyType, RowType valueType, FileFormat fileFormat, Function<String, FileStorePathFactory> format2PathFactory, long suggestedFileSize) {
        return new Builder(fileIO, schemaId, keyType, valueType, fileFormat, format2PathFactory, suggestedFileSize);
    }

    private static class WriteFormatKey {
        private final int level;
        private final boolean isChangelog;

        private WriteFormatKey(int level, boolean isChangelog) {
            this.level = level;
            this.isChangelog = isChangelog;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WriteFormatKey formatKey = (WriteFormatKey)o;
            return this.level == formatKey.level && this.isChangelog == formatKey.isChangelog;
        }

        public int hashCode() {
            return Objects.hash(this.level, this.isChangelog);
        }
    }

    private static class FileWriterContextFactory {
        private final Function<WriteFormatKey, String> key2Format;
        private final Function<WriteFormatKey, String> key2Compress;
        private final Function<WriteFormatKey, String> key2Stats;
        private final Map<Pair<String, String>, Optional<SimpleStatsExtractor>> formatStats2Extractor;
        private final Map<String, SimpleColStatsCollector.Factory[]> statsMode2AvroStats;
        private final Map<String, DataFilePathFactory> format2PathFactory;
        private final Map<String, FileFormat> formatFactory;
        private final Map<String, FormatWriterFactory> format2WriterFactory;
        private final BinaryRow partition;
        private final int bucket;
        private final RowType keyType;
        private final RowType valueType;
        private final RowType writeRowType;
        private final Function<String, FileStorePathFactory> parentFactories;
        private final CoreOptions options;
        private final boolean thinModeEnabled;

        private FileWriterContextFactory(BinaryRow partition, int bucket, RowType keyType, RowType valueType, FileFormat defaultFileFormat, Function<String, FileStorePathFactory> parentFactories, CoreOptions options) {
            this.partition = partition;
            this.bucket = bucket;
            this.keyType = keyType;
            this.valueType = valueType;
            this.parentFactories = parentFactories;
            this.options = options;
            this.thinModeEnabled = options.dataFileThinMode() && this.supportsThinMode(keyType, valueType);
            this.writeRowType = KeyValue.schema(this.thinModeEnabled ? RowType.of() : keyType, valueType);
            Map<Integer, String> fileFormatPerLevel = options.fileFormatPerLevel();
            String defaultFormat = defaultFileFormat.getFormatIdentifier();
            String changelogFormat = options.changelogFileFormat();
            this.key2Format = key -> {
                if (((WriteFormatKey)key).isChangelog && changelogFormat != null) {
                    return changelogFormat;
                }
                return fileFormatPerLevel.getOrDefault(((WriteFormatKey)key).level, defaultFormat);
            };
            String defaultCompress = options.fileCompression();
            String changelogCompression = options.changelogFileCompression();
            Map<Integer, String> fileCompressionPerLevel = options.fileCompressionPerLevel();
            this.key2Compress = key -> {
                if (((WriteFormatKey)key).isChangelog && changelogCompression != null) {
                    return changelogCompression;
                }
                return fileCompressionPerLevel.getOrDefault(((WriteFormatKey)key).level, defaultCompress);
            };
            String statsMode = options.statsMode();
            Map<Integer, String> statsModePerLevel = options.statsModePerLevel();
            String changelogStatsMode = options.changelogFileStatsMode();
            this.key2Stats = key -> {
                if (((WriteFormatKey)key).isChangelog && changelogStatsMode != null) {
                    return changelogStatsMode;
                }
                return statsModePerLevel.getOrDefault(((WriteFormatKey)key).level, statsMode);
            };
            this.formatStats2Extractor = new HashMap<Pair<String, String>, Optional<SimpleStatsExtractor>>();
            this.statsMode2AvroStats = new HashMap<String, SimpleColStatsCollector.Factory[]>();
            this.format2PathFactory = new HashMap<String, DataFilePathFactory>();
            this.format2WriterFactory = new HashMap<String, FormatWriterFactory>();
            this.formatFactory = new HashMap<String, FileFormat>();
        }

        private boolean supportsThinMode(RowType keyType, RowType valueType) {
            Set keyFieldIds = valueType.getFields().stream().map(DataField::id).collect(Collectors.toSet());
            for (DataField field : keyType.getFields()) {
                if (!SpecialFields.isKeyField(field.name())) {
                    return false;
                }
                if (keyFieldIds.contains(field.id() - 0x3FFFFFFF)) continue;
                return false;
            }
            return true;
        }

        private FileWriterContext fileWriterContext(WriteFormatKey key) {
            return new FileWriterContext(this.writerFactory(key), this.statsProducer(key), this.key2Compress.apply(key));
        }

        private SimpleStatsProducer statsProducer(WriteFormatKey key) {
            String format = this.key2Format.apply(key);
            String statsMode = this.key2Stats.apply(key);
            if (format.equals("avro")) {
                SimpleColStatsCollector.Factory[] factories = this.statsMode2AvroStats.computeIfAbsent(statsMode, k -> StatsCollectorFactories.createStatsFactoriesForAvro(statsMode, this.options, this.writeRowType.getFieldNames()));
                SimpleStatsCollector collector = new SimpleStatsCollector(this.writeRowType, factories);
                return SimpleStatsProducer.fromCollector(collector);
            }
            Optional extractor = this.formatStats2Extractor.computeIfAbsent(Pair.of(format, statsMode), k -> this.createSimpleStatsExtractor(format, statsMode));
            return SimpleStatsProducer.fromExtractor(extractor.orElse(null));
        }

        private Optional<SimpleStatsExtractor> createSimpleStatsExtractor(String format, String statsMode) {
            SimpleColStatsCollector.Factory[] statsFactories = StatsCollectorFactories.createStatsFactories(statsMode, this.options, this.writeRowType.getFieldNames(), this.thinModeEnabled ? this.keyType.getFieldNames() : Collections.emptyList());
            boolean isDisabled = Arrays.stream(SimpleColStatsCollector.create(statsFactories)).allMatch(p -> p instanceof NoneSimpleColStatsCollector);
            if (isDisabled) {
                return Optional.empty();
            }
            return this.fileFormat(format).createStatsExtractor(this.writeRowType, statsFactories);
        }

        private DataFilePathFactory pathFactory(WriteFormatKey key) {
            String format = this.key2Format.apply(key);
            return this.format2PathFactory.computeIfAbsent(format, k -> this.parentFactories.apply(format).createDataFilePathFactory(this.partition, this.bucket));
        }

        private FormatWriterFactory writerFactory(WriteFormatKey key) {
            return this.format2WriterFactory.computeIfAbsent(this.key2Format.apply(key), format -> this.fileFormat((String)format).createWriterFactory(this.writeRowType));
        }

        private FileFormat fileFormat(String format) {
            return this.formatFactory.computeIfAbsent(format, k -> FileFormat.fromIdentifier(format, this.options.toConfiguration()));
        }
    }

    public static class Builder {
        private final FileIO fileIO;
        private final long schemaId;
        private final RowType keyType;
        private final RowType valueType;
        private final FileFormat fileFormat;
        private final Function<String, FileStorePathFactory> format2PathFactory;
        private final long suggestedFileSize;

        private Builder(FileIO fileIO, long schemaId, RowType keyType, RowType valueType, FileFormat fileFormat, Function<String, FileStorePathFactory> format2PathFactory, long suggestedFileSize) {
            this.fileIO = fileIO;
            this.schemaId = schemaId;
            this.keyType = keyType;
            this.valueType = valueType;
            this.fileFormat = fileFormat;
            this.format2PathFactory = format2PathFactory;
            this.suggestedFileSize = suggestedFileSize;
        }

        public KeyValueFileWriterFactory build(BinaryRow partition, int bucket, CoreOptions options) {
            FileWriterContextFactory context = new FileWriterContextFactory(partition, bucket, this.keyType, this.valueType, this.fileFormat, this.format2PathFactory, options);
            return new KeyValueFileWriterFactory(this.fileIO, this.schemaId, context, this.suggestedFileSize, options);
        }
    }
}

