/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.mergetree.compact.MergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.options.Options;

public class DeduplicateMergeFunction
implements MergeFunction<KeyValue> {
    private final boolean ignoreDelete;
    private KeyValue latestKv;

    private DeduplicateMergeFunction(boolean ignoreDelete) {
        this.ignoreDelete = ignoreDelete;
    }

    @Override
    public void reset() {
        this.latestKv = null;
    }

    @Override
    public void add(KeyValue kv) {
        if (this.ignoreDelete && kv.valueKind().isRetract()) {
            return;
        }
        this.latestKv = kv;
    }

    @Override
    public KeyValue getResult() {
        return this.latestKv;
    }

    @Override
    public boolean requireCopy() {
        return false;
    }

    public static MergeFunctionFactory<KeyValue> factory() {
        return new Factory(false);
    }

    public static MergeFunctionFactory<KeyValue> factory(Options options) {
        return new Factory(options.get(CoreOptions.IGNORE_DELETE));
    }

    private static class Factory
    implements MergeFunctionFactory<KeyValue> {
        private static final long serialVersionUID = 1L;
        private final boolean ignoreDelete;

        private Factory(boolean ignoreDelete) {
            this.ignoreDelete = ignoreDelete;
        }

        @Override
        public MergeFunction<KeyValue> create(@Nullable int[][] projection) {
            return new DeduplicateMergeFunction(this.ignoreDelete);
        }
    }
}

