/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.metrics;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.stat.descriptive.UnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.moment.SecondMoment;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.apache.commons.math3.stat.ranking.NaNStrategy;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.metrics.DescriptiveStatisticsHistogram;
import org.apache.paimon.metrics.HistogramStatistics;

public class DescriptiveStatisticsHistogramStatistics
extends HistogramStatistics
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final CommonMetricsSnapshot statisticsSummary = new CommonMetricsSnapshot();

    public DescriptiveStatisticsHistogramStatistics(DescriptiveStatisticsHistogram.CircularDoubleArray histogramValues) {
        this(histogramValues.toUnsortedArray());
    }

    public DescriptiveStatisticsHistogramStatistics(double[] values2) {
        this.statisticsSummary.evaluate(values2);
    }

    @Override
    public double getQuantile(double quantile) {
        return this.statisticsSummary.getPercentile(quantile * 100.0);
    }

    @Override
    public long[] getValues() {
        return Arrays.stream(this.statisticsSummary.getValues()).mapToLong(i -> (long)i).toArray();
    }

    @Override
    public int size() {
        return (int)this.statisticsSummary.getCount();
    }

    @Override
    public double getMean() {
        return this.statisticsSummary.getMean();
    }

    @Override
    public double getStdDev() {
        return this.statisticsSummary.getStandardDeviation();
    }

    @Override
    public long getMax() {
        return (long)this.statisticsSummary.getMax();
    }

    @Override
    public long getMin() {
        return (long)this.statisticsSummary.getMin();
    }

    private static class SimpleStats
    extends SecondMoment {
        private static final long serialVersionUID = 1L;
        private double min = Double.NaN;
        private double max = Double.NaN;

        private SimpleStats() {
        }

        public void increment(double d) {
            if (d < this.min || Double.isNaN(this.min)) {
                this.min = d;
            }
            if (d > this.max || Double.isNaN(this.max)) {
                this.max = d;
            }
            super.increment(d);
        }

        public SecondMoment copy() {
            SimpleStats result = new SimpleStats();
            SecondMoment.copy((SecondMoment)this, (SecondMoment)result);
            result.min = this.min;
            result.max = this.max;
            return result;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public double getMean() {
            return this.m1;
        }
    }

    @VisibleForTesting
    static class CommonMetricsSnapshot
    implements UnivariateStatistic,
    Serializable {
        private static final long serialVersionUID = 2L;
        private double[] data;
        private double min = Double.NaN;
        private double max = Double.NaN;
        private double mean = Double.NaN;
        private double stddev = Double.NaN;
        private transient Percentile percentilesImpl;

        CommonMetricsSnapshot() {
        }

        public double evaluate(double[] values2) throws MathIllegalArgumentException {
            return this.evaluate(values2, 0, values2.length);
        }

        public double evaluate(double[] values2, int begin, int length) throws MathIllegalArgumentException {
            this.data = values2;
            SimpleStats secondMoment = new SimpleStats();
            secondMoment.evaluate(values2, begin, length);
            this.mean = secondMoment.getMean();
            this.min = secondMoment.getMin();
            this.max = secondMoment.getMax();
            this.stddev = new StandardDeviation((SecondMoment)secondMoment).getResult();
            return Double.NaN;
        }

        public CommonMetricsSnapshot copy() {
            CommonMetricsSnapshot result = new CommonMetricsSnapshot();
            result.data = Arrays.copyOf(this.data, this.data.length);
            result.min = this.min;
            result.max = this.max;
            result.mean = this.mean;
            result.stddev = this.stddev;
            return result;
        }

        long getCount() {
            return this.data.length;
        }

        double getMin() {
            return this.min;
        }

        double getMax() {
            return this.max;
        }

        double getMean() {
            return this.mean;
        }

        double getStandardDeviation() {
            return this.stddev;
        }

        double getPercentile(double p) {
            this.maybeInitPercentile();
            return this.percentilesImpl.evaluate(p);
        }

        double[] getValues() {
            this.maybeInitPercentile();
            return this.percentilesImpl.getData();
        }

        private void maybeInitPercentile() {
            if (this.percentilesImpl == null) {
                this.percentilesImpl = new Percentile().withNaNStrategy(NaNStrategy.FIXED);
            }
            if (this.data != null) {
                this.percentilesImpl.setData(this.data);
            }
        }
    }
}

