/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.rest.DefaultErrorHandler;
import org.apache.paimon.rest.ErrorHandler;
import org.apache.paimon.rest.ExponentialHttpRetryInterceptor;
import org.apache.paimon.rest.LoggingInterceptor;
import org.apache.paimon.rest.RESTClient;
import org.apache.paimon.rest.RESTObjectMapper;
import org.apache.paimon.rest.RESTRequest;
import org.apache.paimon.rest.RESTResponse;
import org.apache.paimon.rest.auth.RESTAuthFunction;
import org.apache.paimon.rest.auth.RESTAuthParameter;
import org.apache.paimon.rest.exceptions.RESTException;
import org.apache.paimon.rest.responses.ErrorResponse;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.paimon.shade.okhttp3.ConnectionSpec;
import org.apache.paimon.shade.okhttp3.Headers;
import org.apache.paimon.shade.okhttp3.HttpUrl;
import org.apache.paimon.shade.okhttp3.MediaType;
import org.apache.paimon.shade.okhttp3.OkHttpClient;
import org.apache.paimon.shade.okhttp3.Request;
import org.apache.paimon.shade.okhttp3.RequestBody;
import org.apache.paimon.shade.okhttp3.Response;
import org.apache.paimon.utils.StringUtils;

public class HttpClient
implements RESTClient {
    private static final OkHttpClient HTTP_CLIENT = new OkHttpClient.Builder().retryOnConnectionFailure(true).connectionSpecs(Arrays.asList(ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS, ConnectionSpec.CLEARTEXT)).addInterceptor(new ExponentialHttpRetryInterceptor(5)).addInterceptor(new LoggingInterceptor()).connectTimeout(Duration.ofMinutes(3L)).readTimeout(Duration.ofMinutes(3L)).build();
    private static final MediaType MEDIA_TYPE = MediaType.parse("application/json");
    private final String uri;
    private ErrorHandler errorHandler;

    public HttpClient(String uri) {
        this.uri = uri != null && uri.endsWith("/") ? uri.substring(0, uri.length() - 1) : uri;
        this.errorHandler = DefaultErrorHandler.getInstance();
    }

    @VisibleForTesting
    void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public <T extends RESTResponse> T get(String path, Class<T> responseType, RESTAuthFunction restAuthFunction) {
        Map<String, String> authHeaders = HttpClient.getHeaders(path, "GET", "", restAuthFunction);
        Request request = new Request.Builder().url(HttpClient.getRequestUrl(this.uri, path, null)).get().headers(Headers.of(authHeaders)).build();
        return this.exec(request, responseType);
    }

    @Override
    public <T extends RESTResponse> T get(String path, Map<String, String> queryParams, Class<T> responseType, RESTAuthFunction restAuthFunction) {
        Map<String, String> authHeaders = HttpClient.getHeaders(path, queryParams, "GET", "", restAuthFunction);
        Request request = new Request.Builder().url(HttpClient.getRequestUrl(this.uri, path, queryParams)).get().headers(Headers.of(authHeaders)).build();
        return this.exec(request, responseType);
    }

    @Override
    public <T extends RESTResponse> T post(String path, RESTRequest body, RESTAuthFunction restAuthFunction) {
        return this.post(path, body, null, restAuthFunction);
    }

    @Override
    public <T extends RESTResponse> T post(String path, RESTRequest body, Class<T> responseType, RESTAuthFunction restAuthFunction) {
        try {
            String bodyStr = RESTObjectMapper.OBJECT_MAPPER.writeValueAsString(body);
            Map<String, String> authHeaders = HttpClient.getHeaders(path, "POST", bodyStr, restAuthFunction);
            RequestBody requestBody = HttpClient.buildRequestBody(bodyStr);
            Request request = new Request.Builder().url(HttpClient.getRequestUrl(this.uri, path, null)).post(requestBody).headers(Headers.of(authHeaders)).build();
            return this.exec(request, responseType);
        }
        catch (JsonProcessingException e) {
            throw new RESTException(e, "build request failed.", new Object[0]);
        }
    }

    @Override
    public <T extends RESTResponse> T delete(String path, RESTAuthFunction restAuthFunction) {
        Map<String, String> authHeaders = HttpClient.getHeaders(path, "DELETE", "", restAuthFunction);
        Request request = new Request.Builder().url(HttpClient.getRequestUrl(this.uri, path, null)).delete().headers(Headers.of(authHeaders)).build();
        return this.exec(request, null);
    }

    @Override
    public <T extends RESTResponse> T delete(String path, RESTRequest body, RESTAuthFunction restAuthFunction) {
        try {
            String bodyStr = RESTObjectMapper.OBJECT_MAPPER.writeValueAsString(body);
            Map<String, String> authHeaders = HttpClient.getHeaders(path, "DELETE", bodyStr, restAuthFunction);
            RequestBody requestBody = HttpClient.buildRequestBody(bodyStr);
            Request request = new Request.Builder().url(HttpClient.getRequestUrl(this.uri, path, null)).delete(requestBody).headers(Headers.of(authHeaders)).build();
            return this.exec(request, null);
        }
        catch (JsonProcessingException e) {
            throw new RESTException(e, "build request failed.", new Object[0]);
        }
    }

    @VisibleForTesting
    protected static String getRequestUrl(String uri, String path, Map<String, String> queryParams) {
        String fullPath;
        String string = fullPath = StringUtils.isNullOrWhitespaceOnly(path) ? uri : uri + path;
        if (queryParams != null && !queryParams.isEmpty()) {
            HttpUrl httpUrl = HttpUrl.parse(fullPath);
            HttpUrl.Builder builder = httpUrl.newBuilder();
            queryParams.forEach(builder::addQueryParameter);
            fullPath = builder.build().toString();
        }
        return fullPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends RESTResponse> T exec(Request request, Class<T> responseType) {
        try (Response response = HTTP_CLIENT.newCall(request).execute();){
            RESTResponse rESTResponse;
            String responseBodyStr;
            String string = responseBodyStr = response.body() != null ? response.body().string() : null;
            if (!response.isSuccessful()) {
                ErrorResponse error;
                try {
                    error = RESTObjectMapper.OBJECT_MAPPER.readValue(responseBodyStr, ErrorResponse.class);
                }
                catch (JsonProcessingException e) {
                    error = new ErrorResponse(null, null, responseBodyStr != null ? responseBodyStr : "response body is null", response.code());
                }
                String requestId = response.header("x-request-id", "unknown");
                this.errorHandler.accept(error, requestId);
            }
            if (responseType != null && responseBodyStr != null) {
                rESTResponse = (RESTResponse)RESTObjectMapper.OBJECT_MAPPER.readValue(responseBodyStr, responseType);
                return (T)rESTResponse;
            }
            if (responseType == null) {
                rESTResponse = null;
                return (T)rESTResponse;
            }
            throw new RESTException("response body is null.", new Object[0]);
        }
        catch (RESTException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RESTException(e, "rest exception", new Object[0]);
        }
    }

    private static RequestBody buildRequestBody(String body) throws JsonProcessingException {
        return RequestBody.create(body.getBytes(StandardCharsets.UTF_8), MEDIA_TYPE);
    }

    private static Map<String, String> getHeaders(String path, String method, String data, Function<RESTAuthParameter, Map<String, String>> headerFunction) {
        return HttpClient.getHeaders(path, Collections.emptyMap(), method, data, headerFunction);
    }

    private static Map<String, String> getHeaders(String path, Map<String, String> queryParams, String method, String data, Function<RESTAuthParameter, Map<String, String>> headerFunction) {
        RESTAuthParameter restAuthParameter = new RESTAuthParameter(path, queryParams, method, data);
        return headerFunction.apply(restAuthParameter);
    }

    @Override
    public void close() {
    }
}

