/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fs;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.paimon.fs.Path;

public class ExternalPathProvider
implements Serializable {
    private final List<Path> externalTablePaths;
    private final Path relativeBucketPath;
    private int position;

    public ExternalPathProvider(List<Path> externalTablePaths, Path relativeBucketPath) {
        this.externalTablePaths = externalTablePaths;
        this.relativeBucketPath = relativeBucketPath;
        this.position = ThreadLocalRandom.current().nextInt(externalTablePaths.size());
    }

    public Path getNextExternalDataPath(String fileName) {
        ++this.position;
        if (this.position == this.externalTablePaths.size()) {
            this.position = 0;
        }
        return new Path(new Path(this.externalTablePaths.get(this.position), this.relativeBucketPath), fileName);
    }
}

