/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.index.BucketAssigner;
import org.apache.paimon.utils.Int2ShortHashMap;
import org.apache.paimon.utils.ListUtils;

public class SimpleHashBucketAssigner
implements BucketAssigner {
    private final int numAssigners;
    private final int assignId;
    private final long targetBucketRowNumber;
    private final int maxBucketsNum;
    private int maxBucketId;
    private final Map<BinaryRow, SimplePartitionIndex> partitionIndex;

    public SimpleHashBucketAssigner(int numAssigners, int assignId, long targetBucketRowNumber, int maxBucketsNum) {
        this.numAssigners = numAssigners;
        this.assignId = assignId;
        this.targetBucketRowNumber = targetBucketRowNumber;
        this.partitionIndex = new HashMap<BinaryRow, SimplePartitionIndex>();
        this.maxBucketsNum = maxBucketsNum;
    }

    @Override
    public int assign(BinaryRow partition, int hash) {
        int assigned;
        SimplePartitionIndex index = this.partitionIndex.get(partition);
        if (index == null) {
            partition = partition.copy();
            index = new SimplePartitionIndex();
            this.partitionIndex.put(partition, index);
        }
        if ((assigned = index.assign(hash)) > this.maxBucketId) {
            this.maxBucketId = assigned;
        }
        return assigned;
    }

    @Override
    public void prepareCommit(long commitIdentifier) {
    }

    @VisibleForTesting
    Set<BinaryRow> currentPartitions() {
        return this.partitionIndex.keySet();
    }

    private boolean isMyBucket(int bucket) {
        return BucketAssigner.isMyBucket(bucket, this.numAssigners, this.assignId);
    }

    private class SimplePartitionIndex {
        public final Int2ShortHashMap hash2Bucket = new Int2ShortHashMap();
        private final Map<Integer, Long> bucketInformation = new LinkedHashMap<Integer, Long>();
        private final List<Integer> bucketList = new ArrayList<Integer>();
        private int currentBucket;

        private SimplePartitionIndex() {
            this.loadNewBucket();
        }

        public int assign(int hash) {
            if (this.hash2Bucket.containsKey(hash)) {
                return this.hash2Bucket.get(hash);
            }
            Long num = this.bucketInformation.computeIfAbsent(this.currentBucket, bucket -> {
                this.bucketList.add((Integer)bucket);
                return 0L;
            });
            if (num >= SimpleHashBucketAssigner.this.targetBucketRowNumber) {
                if (-1 == SimpleHashBucketAssigner.this.maxBucketsNum || this.bucketInformation.isEmpty() || SimpleHashBucketAssigner.this.maxBucketId < SimpleHashBucketAssigner.this.maxBucketsNum - 1) {
                    this.loadNewBucket();
                } else {
                    this.currentBucket = ListUtils.pickRandomly(this.bucketList);
                }
            }
            this.bucketInformation.compute(this.currentBucket, (i, l) -> l == null ? 1L : l + 1L);
            this.hash2Bucket.put(hash, (short)this.currentBucket);
            return this.currentBucket;
        }

        private void loadNewBucket() {
            for (int i = 0; i < Short.MAX_VALUE; ++i) {
                if (!SimpleHashBucketAssigner.this.isMyBucket(i) || this.bucketInformation.containsKey(i)) continue;
                if (-1 == SimpleHashBucketAssigner.this.maxBucketsNum || i <= SimpleHashBucketAssigner.this.maxBucketsNum - 1) {
                    this.currentBucket = i;
                    return;
                }
                return;
            }
            throw new RuntimeException("Can't find a suitable bucket to assign, all the bucket are assigned?");
        }
    }
}

