/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.table.source.snapshot.ReadPlanStartingScanner;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticFromSnapshotStartingScanner
extends ReadPlanStartingScanner {
    private static final Logger LOG = LoggerFactory.getLogger(StaticFromSnapshotStartingScanner.class);

    public StaticFromSnapshotStartingScanner(SnapshotManager snapshotManager, long snapshotId) {
        super(snapshotManager);
        this.startingSnapshotId = snapshotId;
    }

    @Override
    public ScanMode startingScanMode() {
        return ScanMode.ALL;
    }

    @Override
    public SnapshotReader configure(SnapshotReader snapshotReader) {
        Long earliestSnapshotId = this.snapshotManager.earliestSnapshotId();
        Long latestSnapshotId = this.snapshotManager.latestSnapshotId();
        if (earliestSnapshotId == null || latestSnapshotId == null) {
            throw new IllegalArgumentException("There is currently no snapshot.");
        }
        Preconditions.checkArgument(this.startingSnapshotId >= earliestSnapshotId && this.startingSnapshotId <= latestSnapshotId, "The specified scan snapshotId %s is out of available snapshotId range [%s, %s].", this.startingSnapshotId, earliestSnapshotId, latestSnapshotId);
        return snapshotReader.withMode(ScanMode.ALL).withSnapshot(this.startingSnapshotId);
    }
}

