/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.util.ArrayList;
import java.util.List;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.operation.RestoreFiles;
import org.apache.paimon.operation.WriteRestore;
import org.apache.paimon.utils.SnapshotManager;

public class FileSystemWriteRestore
implements WriteRestore {
    private final SnapshotManager snapshotManager;
    private final FileStoreScan scan;
    private final IndexFileHandler indexFileHandler;

    public FileSystemWriteRestore(CoreOptions options, SnapshotManager snapshotManager, FileStoreScan scan, IndexFileHandler indexFileHandler) {
        this.snapshotManager = snapshotManager;
        this.scan = scan;
        this.indexFileHandler = indexFileHandler;
        if (options.manifestDeleteFileDropStats() && this.scan != null) {
            this.scan.dropStats();
        }
    }

    @Override
    public long latestCommittedIdentifier(String user) {
        return this.snapshotManager.latestSnapshotOfUserFromFilesystem(user).map(Snapshot::commitIdentifier).orElse(Long.MIN_VALUE);
    }

    @Override
    public RestoreFiles restoreFiles(BinaryRow partition, int bucket, boolean scanDynamicBucketIndex, boolean scanDeleteVectorsIndex) {
        Snapshot snapshot = this.snapshotManager.latestSnapshotFromFileSystem();
        if (snapshot == null) {
            return RestoreFiles.empty();
        }
        ArrayList<DataFileMeta> restoreFiles = new ArrayList<DataFileMeta>();
        List<ManifestEntry> entries = this.scan.withSnapshot(snapshot).withPartitionBucket(partition, bucket).plan().files();
        Integer totalBuckets = WriteRestore.extractDataFiles(entries, restoreFiles);
        IndexFileMeta dynamicBucketIndex = null;
        if (scanDynamicBucketIndex) {
            dynamicBucketIndex = this.indexFileHandler.scanHashIndex(snapshot, partition, bucket).orElse(null);
        }
        List<IndexFileMeta> deleteVectorsIndex = null;
        if (scanDeleteVectorsIndex) {
            deleteVectorsIndex = this.indexFileHandler.scan(snapshot, "DELETION_VECTORS", partition, bucket);
        }
        return new RestoreFiles(snapshot, totalBuckets, restoreFiles, dynamicBucketIndex, deleteVectorsIndex);
    }
}

