/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.paimon.shade.hc.core5.annotation.Internal;
import org.apache.paimon.shade.hc.core5.concurrent.FutureCallback;
import org.apache.paimon.shade.hc.core5.http.impl.nio.BufferedData;
import org.apache.paimon.shade.hc.core5.http2.impl.nio.ClientH2IOEventHandler;
import org.apache.paimon.shade.hc.core5.http2.impl.nio.ClientH2StreamMultiplexerFactory;
import org.apache.paimon.shade.hc.core5.http2.impl.nio.PrefaceHandlerBase;
import org.apache.paimon.shade.hc.core5.http2.impl.nio.ProtocolNegotiationException;
import org.apache.paimon.shade.hc.core5.http2.ssl.ApplicationProtocol;
import org.apache.paimon.shade.hc.core5.reactor.IOSession;
import org.apache.paimon.shade.hc.core5.reactor.ProtocolIOSession;
import org.apache.paimon.shade.hc.core5.reactor.ssl.TlsDetails;
import org.apache.paimon.shade.hc.core5.util.Args;
import org.apache.paimon.shade.hc.core5.util.TextUtils;

@Internal
public class ClientH2PrefaceHandler
extends PrefaceHandlerBase {
    static final byte[] PREFACE = new byte[]{80, 82, 73, 32, 42, 32, 72, 84, 84, 80, 47, 50, 46, 48, 13, 10, 13, 10, 83, 77, 13, 10, 13, 10};
    private final ClientH2StreamMultiplexerFactory http2StreamHandlerFactory;
    private final boolean strictALPNHandshake;
    private final AtomicBoolean initialized;
    private volatile ByteBuffer preface;
    private volatile BufferedData inBuf;

    public ClientH2PrefaceHandler(ProtocolIOSession ioSession, ClientH2StreamMultiplexerFactory http2StreamHandlerFactory, boolean strictALPNHandshake) {
        this(ioSession, http2StreamHandlerFactory, strictALPNHandshake, null);
    }

    public ClientH2PrefaceHandler(ProtocolIOSession ioSession, ClientH2StreamMultiplexerFactory http2StreamHandlerFactory, boolean strictALPNHandshake, FutureCallback<ProtocolIOSession> resultCallback) {
        super(ioSession, resultCallback);
        this.http2StreamHandlerFactory = Args.notNull(http2StreamHandlerFactory, "HTTP/2 stream handler factory");
        this.strictALPNHandshake = strictALPNHandshake;
        this.initialized = new AtomicBoolean();
    }

    private void initialize() throws IOException {
        TlsDetails tlsDetails = this.ioSession.getTlsDetails();
        if (tlsDetails != null) {
            String applicationProtocol = tlsDetails.getApplicationProtocol();
            if (TextUtils.isEmpty(applicationProtocol)) {
                if (this.strictALPNHandshake) {
                    throw new ProtocolNegotiationException("ALPN: missing application protocol");
                }
            } else if (!ApplicationProtocol.HTTP_2.id.equals(applicationProtocol)) {
                throw new ProtocolNegotiationException("ALPN: unexpected application protocol '" + applicationProtocol + "'");
            }
        }
        this.preface = ByteBuffer.wrap(PREFACE);
        this.ioSession.setEvent(4);
    }

    private boolean writeOutPreface(IOSession session, ByteBuffer preface) throws IOException {
        if (preface.hasRemaining()) {
            session.write(preface);
        }
        if (!preface.hasRemaining()) {
            session.clearEvent(4);
            ByteBuffer data = this.inBuf != null ? this.inBuf.data() : null;
            this.startProtocol(new ClientH2IOEventHandler(this.http2StreamHandlerFactory.create(this.ioSession)), data);
            if (this.inBuf != null) {
                this.inBuf.clear();
            }
            return true;
        }
        return false;
    }

    @Override
    public void connected(IOSession session) throws IOException {
        if (this.initialized.compareAndSet(false, true)) {
            this.initialize();
        }
    }

    @Override
    public void outputReady(IOSession session) throws IOException {
        ByteBuffer preface;
        if (this.initialized.compareAndSet(false, true)) {
            this.initialize();
        }
        if ((preface = this.preface) != null) {
            if (this.writeOutPreface(session, preface)) {
                this.preface = null;
            }
        } else {
            throw new ProtocolNegotiationException("Unexpected output");
        }
    }

    @Override
    public void inputReady(IOSession session, ByteBuffer src) throws IOException {
        ByteBuffer preface;
        if (src != null) {
            if (this.inBuf == null) {
                this.inBuf = BufferedData.allocate(src.remaining());
            }
            this.inBuf.put(src);
        }
        if ((preface = this.preface) != null) {
            if (this.writeOutPreface(session, preface)) {
                this.preface = null;
            }
        } else {
            throw new ProtocolNegotiationException("Unexpected input");
        }
    }

    public String toString() {
        return this.getClass().getName();
    }
}

