/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.tools.ci.suffixcheck;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.paimon.tools.ci.utils.dependency.DependencyParser;
import org.apache.paimon.tools.ci.utils.shared.Dependency;
import org.apache.paimon.tools.ci.utils.shared.DependencyTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScalaSuffixChecker {
    private static final Logger LOG = LoggerFactory.getLogger(ScalaSuffixChecker.class);
    private static final Pattern moduleNamePattern = Pattern.compile(".* --- maven-dependency-plugin.* @ (.*) ---.*");
    private static final Pattern blockPattern = Pattern.compile(".* [+|\\\\].*");
    private static final Pattern scalaSuffixPattern = Pattern.compile("_2.1[0-9]");
    private static final Set<String> EXCLUDED_MODULES = new HashSet<String>(Arrays.asList(new String[0]));

    public static void main(String[] args) throws IOException {
        Collection<String> violations;
        if (args.length < 2) {
            System.out.println("Usage: ScalaSuffixChecker <pathMavenBuildOutput> <pathPaimonRoot>");
            System.exit(1);
        }
        Path mavenOutputPath = Paths.get(args[0], new String[0]);
        Path paimonRootPath = Paths.get(args[1], new String[0]);
        ParseResult parseResult = ScalaSuffixChecker.parseMavenOutput(mavenOutputPath);
        if (parseResult.getCleanModules().isEmpty()) {
            LOG.error("Parsing found 0 scala-free modules; the parsing is likely broken.");
            System.exit(1);
        }
        if (parseResult.getInfectedModules().isEmpty()) {
            LOG.error("Parsing found 0 scala-dependent modules; the parsing is likely broken.");
            System.exit(1);
        }
        if (!(violations = ScalaSuffixChecker.checkScalaSuffixes(parseResult, paimonRootPath)).isEmpty()) {
            LOG.error("Violations found:{}", (Object)violations.stream().collect(Collectors.joining("\n\t", "\n\t", "")));
            System.exit(1);
        }
    }

    private static ParseResult parseMavenOutput(Path path) throws IOException {
        HashSet<String> cleanModules = new HashSet<String>();
        HashSet<String> infectedModules = new HashSet<String>();
        Map<String, DependencyTree> dependenciesByModule = DependencyParser.parseDependencyTreeOutput(path);
        for (String module : dependenciesByModule.keySet()) {
            String moduleName = ScalaSuffixChecker.stripScalaSuffix(module);
            if (ScalaSuffixChecker.isExcluded(moduleName)) continue;
            LOG.trace("Processing module '{}'.", (Object)moduleName);
            List dependencies = dependenciesByModule.get(module).flatten().collect(Collectors.toList());
            boolean infected = false;
            for (Dependency dependency : dependencies) {
                boolean dependsOnScala = ScalaSuffixChecker.dependsOnScala(dependency);
                boolean isTestDependency = dependency.getScope().get().equals("test");
                boolean isExcluded = ScalaSuffixChecker.isExcluded(dependency.getArtifactId());
                LOG.trace("\tdependency:{}", (Object)dependency);
                LOG.trace("\t\tdepends-on-scala:{}", (Object)dependsOnScala);
                LOG.trace("\t\tis-test-dependency:{}", (Object)isTestDependency);
                LOG.trace("\t\tis-excluded:{}", (Object)isExcluded);
                if (!dependsOnScala || isTestDependency || isExcluded) continue;
                LOG.trace("\t\tOutbreak detected at {}!", (Object)moduleName);
                infected = true;
            }
            if (infected) {
                infectedModules.add(moduleName);
                continue;
            }
            cleanModules.add(moduleName);
        }
        return new ParseResult(cleanModules, infectedModules);
    }

    private static String stripScalaSuffix(String moduleName) {
        int i = moduleName.indexOf("_2.");
        return i > 0 ? moduleName.substring(0, i) : moduleName;
    }

    private static boolean dependsOnScala(Dependency dependency) {
        return dependency.getGroupId().contains("org.scala-lang") || scalaSuffixPattern.matcher(dependency.getArtifactId()).find();
    }

    private static Collection<String> checkScalaSuffixes(ParseResult parseResult, Path paimonRootPath) throws IOException {
        ArrayList<String> violations = new ArrayList<String>();
        ArrayList<String> excludedModules = new ArrayList<String>();
        excludedModules.add("paimon-docs");
        excludedModules.addAll(ScalaSuffixChecker.getEndToEndTestModules(paimonRootPath));
        for (String excludedModule : excludedModules) {
            parseResult.getCleanModules().remove(excludedModule);
            parseResult.getInfectedModules().remove(excludedModule);
        }
        violations.addAll(ScalaSuffixChecker.checkCleanModules(parseResult.getCleanModules(), paimonRootPath));
        violations.addAll(ScalaSuffixChecker.checkInfectedModules(parseResult.getInfectedModules(), paimonRootPath));
        return violations;
    }

    private static Collection<String> getEndToEndTestModules(Path paimonRootPath) throws IOException {
        try (Stream<Path> pathStream = Files.walk(paimonRootPath.resolve("paimon-e2e-tests"), 5, new FileVisitOption[0]);){
            Collection collection = pathStream.filter(path -> path.getFileName().toString().equals("pom.xml")).map(path -> path.getParent().getFileName().toString()).collect(Collectors.toList());
            return collection;
        }
    }

    private static Collection<String> checkCleanModules(Collection<String> modules, Path paimonRootPath) throws IOException {
        return ScalaSuffixChecker.checkModules(modules, paimonRootPath, "_${scala.binary.version}", "Scala-free module '%s' is referenced with scala suffix in '%s'.");
    }

    private static Collection<String> checkInfectedModules(Collection<String> modules, Path paimonRootPath) throws IOException {
        return ScalaSuffixChecker.checkModules(modules, paimonRootPath, "", "Scala-dependent module '%s' is referenced without scala suffix in '%s'.");
    }

    private static Collection<String> checkModules(Collection<String> modules, Path paimonRootPath, String moduleSuffix, String violationTemplate) throws IOException {
        ArrayList<String> sortedModules = new ArrayList<String>(modules);
        sortedModules.sort(String::compareTo);
        ArrayList<String> violations = new ArrayList<String>();
        for (String module : sortedModules) {
            int numPreviousViolations = violations.size();
            try (Stream<Path> pathStream = Files.walk(paimonRootPath, 3, new FileVisitOption[0]);){
                List pomFiles = pathStream.filter(path -> path.getFileName().toString().equals("pom.xml")).collect(Collectors.toList());
                for (Path pomFile : pomFiles) {
                    Stream<String> lines = Files.lines(pomFile, StandardCharsets.UTF_8);
                    Throwable throwable = null;
                    try {
                        boolean existsCleanReference = lines.anyMatch(line -> line.contains(module + moduleSuffix + "</artifactId>"));
                        if (!existsCleanReference) continue;
                        violations.add(String.format(violationTemplate, module, paimonRootPath.relativize(pomFile)));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (lines == null) continue;
                        if (throwable != null) {
                            try {
                                lines.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        lines.close();
                    }
                }
            }
            if (numPreviousViolations != violations.size()) continue;
            LOG.info("OK {}", (Object)module);
        }
        return violations;
    }

    private static boolean isExcluded(String line) {
        return EXCLUDED_MODULES.stream().anyMatch(line::contains);
    }

    private static class ParseResult {
        private final Set<String> cleanModules;
        private final Set<String> infectedModules;

        private ParseResult(Set<String> cleanModules, Set<String> infectedModules) {
            this.cleanModules = cleanModules;
            this.infectedModules = infectedModules;
        }

        public Set<String> getCleanModules() {
            return this.cleanModules;
        }

        public Set<String> getInfectedModules() {
            return this.infectedModules;
        }
    }
}

