/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.tools.ci.utils.shared;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.paimon.shade.guava30.com.google.common.graph.Traverser;
import org.apache.paimon.tools.ci.utils.shared.Dependency;

public class DependencyTree {
    private final Map<String, Node> lookup = new LinkedHashMap<String, Node>();
    private final List<Node> directDependencies = new ArrayList<Node>();

    public void addDirectDependency(Dependency dependency) {
        String key = DependencyTree.getKey(dependency);
        if (this.lookup.containsKey(key)) {
            return;
        }
        Node node = new Node(dependency, null);
        this.lookup.put(key, node);
        this.directDependencies.add(node);
    }

    public void addTransitiveDependencyTo(Dependency transitiveDependency, Dependency parent) {
        String key = DependencyTree.getKey(transitiveDependency);
        if (this.lookup.containsKey(key)) {
            return;
        }
        Node node = this.lookup.get(DependencyTree.getKey(parent)).addTransitiveDependency(transitiveDependency);
        this.lookup.put(key, node);
    }

    public List<Dependency> getPathTo(Dependency dependency) {
        LinkedList<Dependency> path = new LinkedList<Dependency>();
        Node node = this.lookup.get(DependencyTree.getKey(dependency));
        path.addFirst(node.dependency);
        while (!node.isRoot()) {
            node = node.parent;
            path.addFirst(node.dependency);
        }
        return path;
    }

    public Stream<Dependency> flatten() {
        return StreamSupport.stream(Traverser.forTree(node -> ((Node)node).children).depthFirstPreOrder(this.directDependencies).spliterator(), false).map(node -> ((Node)node).dependency);
    }

    static String getKey(Dependency dependency) {
        return dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion() + ":" + dependency.getClassifier().orElse("(no-classifier)");
    }

    private static final class Node {
        private final Dependency dependency;
        @Nullable
        private final Node parent;
        private final List<Node> children = new ArrayList<Node>();

        private Node(Dependency dependency, @Nullable Node parent) {
            this.dependency = dependency;
            this.parent = parent;
        }

        public Node addTransitiveDependency(Dependency dependency) {
            Node node = new Node(dependency, this);
            this.children.add(node);
            return node;
        }

        private boolean isRoot() {
            return this.parent == null;
        }
    }
}

