/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.compression;

import com.github.luben.zstd.RecyclingBufferPool;
import com.github.luben.zstd.ZstdOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.paimon.compression.BlockCompressor;
import org.apache.paimon.compression.BufferCompressionException;

public class ZstdBlockCompressor
implements BlockCompressor {
    private static final int MAX_BLOCK_SIZE = 131072;
    private final int level;

    public ZstdBlockCompressor(int level) {
        this.level = level;
    }

    @Override
    public int getMaxCompressedSize(int srcSize) {
        return 8 + this.zstdMaxCompressedLength(srcSize);
    }

    private int zstdMaxCompressedLength(int uncompressedSize) {
        int result = uncompressedSize + (uncompressedSize >>> 8);
        if (uncompressedSize < 131072) {
            result += 131072 - uncompressedSize >>> 11;
        }
        return result;
    }

    @Override
    public int compress(byte[] src, int srcOff, int srcLen, byte[] dst, int dstOff) throws BufferCompressionException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(dst, dstOff);
        try (ZstdOutputStream zstdStream = new ZstdOutputStream((OutputStream)stream, RecyclingBufferPool.INSTANCE, this.level);){
            zstdStream.setWorkers(0);
            zstdStream.write(src, srcOff, srcLen);
        }
        catch (IOException e) {
            throw new BufferCompressionException(e);
        }
        return stream.position() - dstOff;
    }

    private static class ByteArrayOutputStream
    extends OutputStream {
        private final byte[] buf;
        private int position;

        public ByteArrayOutputStream(byte[] buf, int position) {
            this.buf = buf;
            this.position = position;
        }

        @Override
        public void write(int b) {
            this.buf[this.position] = (byte)b;
            ++this.position;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
                throw new IndexOutOfBoundsException();
            }
            try {
                System.arraycopy(b, off, this.buf, this.position, len);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IOException(e);
            }
            this.position += len;
        }

        int position() {
            return this.position;
        }
    }
}

