/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.predicate;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.data.serializer.ListSerializer;
import org.apache.paimon.data.serializer.NullableSerializer;
import org.apache.paimon.io.DataInputViewStreamWrapper;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.io.DataOutputViewStreamWrapper;
import org.apache.paimon.predicate.FieldRef;
import org.apache.paimon.predicate.LeafFunction;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateVisitor;
import org.apache.paimon.types.DataType;
import org.apache.paimon.utils.InternalRowUtils;

public class LeafPredicate
implements Predicate {
    private static final long serialVersionUID = 1L;
    private final LeafFunction function;
    private final DataType type;
    private final int fieldIndex;
    private final String fieldName;
    private transient List<Object> literals;

    public LeafPredicate(LeafFunction function, DataType type, int fieldIndex, String fieldName, List<Object> literals) {
        this.function = function;
        this.type = type;
        this.fieldIndex = fieldIndex;
        this.fieldName = fieldName;
        this.literals = literals;
    }

    public LeafFunction function() {
        return this.function;
    }

    public DataType type() {
        return this.type;
    }

    public int index() {
        return this.fieldIndex;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public FieldRef fieldRef() {
        return new FieldRef(this.fieldIndex, this.fieldName, this.type);
    }

    public List<Object> literals() {
        return this.literals;
    }

    public LeafPredicate copyWithNewIndex(int fieldIndex) {
        return new LeafPredicate(this.function, this.type, fieldIndex, this.fieldName, this.literals);
    }

    @Override
    public boolean test(InternalRow row) {
        return this.function.test(this.type, InternalRowUtils.get(row, this.fieldIndex, this.type), this.literals);
    }

    @Override
    public boolean test(long rowCount, InternalRow minValues, InternalRow maxValues, InternalArray nullCounts) {
        Long nullCount;
        Object min = InternalRowUtils.get(minValues, this.fieldIndex, this.type);
        Object max = InternalRowUtils.get(maxValues, this.fieldIndex, this.type);
        Long l = nullCount = nullCounts.isNullAt(this.fieldIndex) ? null : Long.valueOf(nullCounts.getLong(this.fieldIndex));
        if (!(nullCount != null && rowCount == nullCount || min != null && max != null)) {
            return true;
        }
        return this.function.test(this.type, rowCount, min, max, nullCount, this.literals);
    }

    @Override
    public Optional<Predicate> negate() {
        return this.function.negate().map(negate -> new LeafPredicate((LeafFunction)negate, this.type, this.fieldIndex, this.fieldName, this.literals));
    }

    @Override
    public <T> T visit(PredicateVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LeafPredicate that = (LeafPredicate)o;
        return this.fieldIndex == that.fieldIndex && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.function, that.function) && Objects.equals(this.type, that.type) && Objects.equals(this.literals, that.literals);
    }

    public int hashCode() {
        return Objects.hash(this.function, this.type, this.fieldIndex, this.fieldName, this.literals);
    }

    public String toString() {
        String literalsStr = this.literals == null || this.literals.isEmpty() ? "" : (this.literals.size() == 1 ? Objects.toString(this.literals.get(0)) : this.literals.toString());
        return literalsStr.isEmpty() ? this.function + "(" + this.fieldName + ")" : this.function + "(" + this.fieldName + ", " + literalsStr + ")";
    }

    private ListSerializer<Object> objectsSerializer() {
        return new ListSerializer<Object>(NullableSerializer.wrapIfNullIsNotSupported(InternalSerializers.create(this.type)));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.objectsSerializer().serialize(this.literals, (DataOutputView)new DataOutputViewStreamWrapper(out));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.literals = this.objectsSerializer().deserialize(new DataInputViewStreamWrapper(in));
    }
}

