/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.columnar;

import javax.annotation.Nullable;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.PartitionInfo;
import org.apache.paimon.data.columnar.ColumnVector;
import org.apache.paimon.data.columnar.ColumnarRow;
import org.apache.paimon.data.columnar.VectorizedColumnBatch;
import org.apache.paimon.fs.Path;
import org.apache.paimon.reader.FileRecordIterator;
import org.apache.paimon.utils.RecyclableIterator;
import org.apache.paimon.utils.VectorMappingUtils;

public class ColumnarRowIterator
extends RecyclableIterator<InternalRow>
implements FileRecordIterator<InternalRow> {
    protected final Path filePath;
    protected final ColumnarRow row;
    protected final Runnable recycler;
    protected int num;
    protected int nextPos;
    protected long nextFilePos;

    public ColumnarRowIterator(Path filePath, ColumnarRow row, @Nullable Runnable recycler) {
        super(recycler);
        this.filePath = filePath;
        this.row = row;
        this.recycler = recycler;
    }

    public void reset(long nextFilePos) {
        this.num = this.row.batch().getNumRows();
        this.nextPos = 0;
        this.nextFilePos = nextFilePos;
    }

    @Override
    @Nullable
    public InternalRow next() {
        if (this.nextPos < this.num) {
            this.row.setRowId(this.nextPos++);
            ++this.nextFilePos;
            return this.row;
        }
        return null;
    }

    @Override
    public long returnedPosition() {
        return this.nextFilePos - 1L;
    }

    @Override
    public Path filePath() {
        return this.filePath;
    }

    protected ColumnarRowIterator copy(ColumnVector[] vectors) {
        ColumnarRowIterator newIterator = new ColumnarRowIterator(this.filePath, this.row.copy(vectors), this.recycler);
        newIterator.reset(this.nextFilePos);
        return newIterator;
    }

    public ColumnarRowIterator mapping(@Nullable PartitionInfo partitionInfo, @Nullable int[] indexMapping) {
        if (partitionInfo != null || indexMapping != null) {
            VectorizedColumnBatch vectorizedColumnBatch = this.row.batch();
            ColumnVector[] vectors = vectorizedColumnBatch.columns;
            if (partitionInfo != null) {
                vectors = VectorMappingUtils.createPartitionMappedVectors(partitionInfo, vectors);
            }
            if (indexMapping != null) {
                vectors = VectorMappingUtils.createMappedVectors(indexMapping, vectors);
            }
            return this.copy(vectors);
        }
        return this;
    }
}

