/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.types;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.DataTypeVisitor;
import org.apache.paimon.utils.Preconditions;

@Public
public abstract class DataType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean isNullable;
    private final DataTypeRoot typeRoot;

    public DataType(boolean isNullable, DataTypeRoot typeRoot) {
        this.isNullable = isNullable;
        this.typeRoot = Preconditions.checkNotNull(typeRoot);
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public DataTypeRoot getTypeRoot() {
        return this.typeRoot;
    }

    public boolean is(DataTypeRoot typeRoot) {
        return this.typeRoot == typeRoot;
    }

    public boolean isAnyOf(DataTypeRoot ... typeRoots) {
        return Arrays.stream(typeRoots).anyMatch(tr -> this.typeRoot == tr);
    }

    public boolean isAnyOf(DataTypeFamily ... typeFamilies) {
        return Arrays.stream(typeFamilies).anyMatch(tf -> this.typeRoot.getFamilies().contains(tf));
    }

    public boolean is(DataTypeFamily family) {
        return this.typeRoot.getFamilies().contains((Object)family);
    }

    public abstract int defaultSize();

    public abstract DataType copy(boolean var1);

    public final DataType copy() {
        return this.copy(this.isNullable);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataType that = (DataType)o;
        return this.isNullable == that.isNullable && this.typeRoot == that.typeRoot;
    }

    public boolean equalsIgnoreNullable(DataType o) {
        return Objects.equals(this.copy(true), o.copy(true));
    }

    public boolean equalsIgnoreFieldId(DataType o) {
        return this.equals(o);
    }

    public boolean isPrunedFrom(Object o) {
        return this.equals(o);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isNullable, this.typeRoot});
    }

    public abstract String asSQLString();

    public void serializeJson(JsonGenerator generator) throws IOException {
        generator.writeString(this.asSQLString());
    }

    protected String withNullability(String format, Object ... params) {
        if (!this.isNullable) {
            return String.format(format + " NOT NULL", params);
        }
        return String.format(format, params);
    }

    public String toString() {
        return this.asSQLString();
    }

    public abstract <R> R accept(DataTypeVisitor<R> var1);

    public void collectFieldIds(Set<Integer> fieldIds) {
    }

    public DataType notNull() {
        return this.copy(false);
    }

    public DataType nullable() {
        return this.copy(true);
    }
}

