/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.types;

import java.util.Objects;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.DataTypeVisitor;

@Public
public final class VarBinaryType
extends DataType {
    private static final long serialVersionUID = 1L;
    public static final int MIN_LENGTH = 1;
    public static final int MAX_LENGTH = Integer.MAX_VALUE;
    public static final int DEFAULT_LENGTH = 1;
    private static final String FORMAT = "VARBINARY(%d)";
    private static final String MAX_FORMAT = "BYTES";
    private final int length;

    public VarBinaryType(boolean isNullable, int length) {
        super(isNullable, DataTypeRoot.VARBINARY);
        if (length < 1) {
            throw new IllegalArgumentException(String.format("Variable binary string length must be between %d and %d (both inclusive).", 1, Integer.MAX_VALUE));
        }
        this.length = length;
    }

    public VarBinaryType(int length) {
        this(true, length);
    }

    public VarBinaryType() {
        this(1);
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public int defaultSize() {
        return this.length == Integer.MAX_VALUE ? 20 : this.length;
    }

    @Override
    public DataType copy(boolean isNullable) {
        return new VarBinaryType(isNullable, this.length);
    }

    @Override
    public String asSQLString() {
        if (this.length == Integer.MAX_VALUE) {
            return this.withNullability(MAX_FORMAT, new Object[0]);
        }
        return this.withNullability(FORMAT, this.length);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VarBinaryType that = (VarBinaryType)o;
        return this.length == that.length;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.length);
    }

    @Override
    public <R> R accept(DataTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }
}

