/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.shade.guava30.com.google.common.collect.Lists;
import org.apache.paimon.utils.ThreadUtils;

public class ThreadPoolUtils {
    public static ThreadPoolExecutor createCachedThreadPool(int threadNum, String namePrefix) {
        return ThreadPoolUtils.createCachedThreadPool(threadNum, namePrefix, new LinkedBlockingQueue<Runnable>());
    }

    public static ThreadPoolExecutor createCachedThreadPool(int threadNum, String namePrefix, BlockingQueue<Runnable> workQueue) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(threadNum, threadNum, 1L, TimeUnit.MINUTES, workQueue, ThreadUtils.newDaemonThreadFactory(namePrefix));
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public static ScheduledExecutorService createScheduledThreadPool(int threadNum, String namePrefix) {
        return new ScheduledThreadPoolExecutor(threadNum, ThreadUtils.newDaemonThreadFactory(namePrefix));
    }

    public static <T, U> Iterable<T> sequentialBatchedExecute(final ThreadPoolExecutor executor, final Function<U, List<T>> processor, List<U> input, @Nullable Integer queueSize) {
        if (queueSize == null) {
            queueSize = executor.getMaximumPoolSize();
        }
        if (queueSize <= 0) {
            throw new NegativeArraySizeException("queue size should not be negative");
        }
        final ArrayDeque stack = new ArrayDeque(Lists.partition(input, (int)queueSize));
        return () -> new Iterator<T>(){
            Iterator activeList = null;
            Object next = null;

            @Override
            public boolean hasNext() {
                this.advanceIfNeeded();
                return this.next != null;
            }

            @Override
            public T next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object result = this.next;
                this.next = null;
                return result;
            }

            private void advanceIfNeeded() {
                while (this.next == null) {
                    if (this.activeList != null && this.activeList.hasNext()) {
                        this.next = this.activeList.next();
                        continue;
                    }
                    if (stack.isEmpty()) {
                        return;
                    }
                    this.activeList = ThreadPoolUtils.randomlyExecuteSequentialReturn(executor, processor, (Collection)stack.poll());
                }
            }
        };
    }

    public static <U> void randomlyOnlyExecute(ExecutorService executor, Consumer<U> processor, Collection<U> input) {
        ArrayList futures = new ArrayList(input.size());
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        for (Object u : input) {
            futures.add(executor.submit(() -> {
                Thread.currentThread().setContextClassLoader(cl);
                processor.accept(u);
            }));
        }
        ThreadPoolUtils.awaitAllFutures(futures);
    }

    public static <U, T> Iterator<T> randomlyExecuteSequentialReturn(ExecutorService executor, Function<U, List<T>> processor, Collection<U> input) {
        ArrayList<Future<List<T>>> futures = new ArrayList<Future<List<T>>>(input.size());
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        for (Object u : input) {
            futures.add(executor.submit(() -> {
                Thread.currentThread().setContextClassLoader(cl);
                return (List)processor.apply(u);
            }));
        }
        return ThreadPoolUtils.futuresToIterIter(futures);
    }

    private static <T> Iterator<T> futuresToIterIter(List<Future<List<T>>> futures) {
        final ArrayDeque<Future<List<T>>> queue = new ArrayDeque<Future<List<T>>>(futures);
        return Iterators.concat((Iterator)new Iterator<Iterator<T>>(){

            @Override
            public boolean hasNext() {
                return !queue.isEmpty();
            }

            @Override
            public Iterator<T> next() {
                try {
                    return ((List)((Future)queue.poll()).get()).iterator();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private static void awaitAllFutures(List<Future<?>> futures) {
        for (Future<?> future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

