/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.columnar.heap;

import java.util.Arrays;
import org.apache.paimon.data.columnar.heap.AbstractHeapVector;
import org.apache.paimon.data.columnar.writable.WritableShortVector;

public class HeapShortVector
extends AbstractHeapVector
implements WritableShortVector {
    private static final long serialVersionUID = -8278486456144676292L;
    public short[] vector;

    public HeapShortVector(int len) {
        super(len);
        this.vector = new short[len];
    }

    @Override
    void reserveForHeapVector(int newCapacity) {
        if (this.vector.length < newCapacity) {
            this.vector = Arrays.copyOf(this.vector, newCapacity);
        }
    }

    @Override
    public short getShort(int i) {
        if (this.dictionary == null) {
            return this.vector[i];
        }
        return (short)this.dictionary.decodeToInt(this.dictionaryIds.vector[i]);
    }

    @Override
    public void setShort(int i, short value) {
        this.vector[i] = value;
    }

    @Override
    public void fill(short value) {
        Arrays.fill(this.vector, value);
    }

    @Override
    public void reset() {
        super.reset();
        if (this.vector.length != this.capacity) {
            this.vector = new short[this.capacity];
        } else {
            Arrays.fill(this.vector, (short)0);
        }
    }
}

