/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.serializer;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryArray;
import org.apache.paimon.data.BinaryMap;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.serializer.InternalArraySerializer;
import org.apache.paimon.data.serializer.InternalMapSerializer;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySegmentUtils;
import org.apache.paimon.memory.MemorySlice;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeChecks;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.VarLengthIntUtils;

public class RowCompactedSerializer
implements Serializer<InternalRow> {
    private static final long serialVersionUID = 1L;
    private final InternalRow.FieldGetter[] getters;
    private final FieldWriter[] writers;
    private final FieldReader[] readers;
    private final RowType rowType;
    @Nullable
    private RowWriter rowWriter;
    @Nullable
    private RowReader rowReader;

    public static int calculateBitSetInBytes(int arity) {
        return (arity + 7 + 8) / 8;
    }

    public RowCompactedSerializer(RowType rowType) {
        this.getters = new InternalRow.FieldGetter[rowType.getFieldCount()];
        this.writers = new FieldWriter[rowType.getFieldCount()];
        this.readers = new FieldReader[rowType.getFieldCount()];
        for (int i = 0; i < rowType.getFieldCount(); ++i) {
            DataType type = rowType.getTypeAt(i);
            this.getters[i] = InternalRow.createFieldGetter(type, i);
            this.writers[i] = RowCompactedSerializer.createFieldWriter(type);
            this.readers[i] = RowCompactedSerializer.createFieldReader(type);
        }
        this.rowType = rowType;
    }

    @VisibleForTesting
    RowType rowType() {
        return this.rowType;
    }

    @Override
    public Serializer<InternalRow> duplicate() {
        return new RowCompactedSerializer(this.rowType);
    }

    @Override
    public InternalRow copy(InternalRow from) {
        return this.deserialize(this.serializeToBytes(from));
    }

    @Override
    public void serialize(InternalRow record, DataOutputView target) throws IOException {
        byte[] bytes = this.serializeToBytes(record);
        VarLengthIntUtils.encodeInt(target, bytes.length);
        target.write(bytes);
    }

    @Override
    public InternalRow deserialize(DataInputView source) throws IOException {
        int len = VarLengthIntUtils.decodeInt(source);
        byte[] bytes = new byte[len];
        source.readFully(bytes);
        return this.deserialize(bytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowCompactedSerializer that = (RowCompactedSerializer)o;
        return Objects.equals(this.rowType, that.rowType);
    }

    public int hashCode() {
        return Objects.hash(this.rowType);
    }

    public byte[] serializeToBytes(InternalRow record) {
        if (this.rowWriter == null) {
            this.rowWriter = new RowWriter(RowCompactedSerializer.calculateBitSetInBytes(this.getters.length));
        }
        this.rowWriter.reset();
        this.rowWriter.writeRowKind(record.getRowKind());
        for (int i = 0; i < this.getters.length; ++i) {
            Object field = this.getters[i].getFieldOrNull(record);
            if (field == null) {
                this.rowWriter.setNullAt(i);
                continue;
            }
            this.writers[i].writeField(this.rowWriter, i, field);
        }
        return this.rowWriter.copyBuffer();
    }

    public InternalRow deserialize(byte[] bytes) {
        if (this.rowReader == null) {
            this.rowReader = new RowReader(RowCompactedSerializer.calculateBitSetInBytes(this.getters.length));
        }
        this.rowReader.pointTo(bytes);
        GenericRow row = new GenericRow(this.readers.length);
        row.setRowKind(this.rowReader.readRowKind());
        for (int i = 0; i < this.readers.length; ++i) {
            row.setField(i, this.rowReader.isNullAt(i) ? null : this.readers[i].readField(this.rowReader, i));
        }
        return row;
    }

    public Comparator<MemorySlice> createSliceComparator() {
        return new SliceComparator(this.rowType);
    }

    private static FieldWriter createFieldWriter(DataType fieldType) {
        FieldWriter fieldWriter;
        switch (fieldType.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                fieldWriter = (writer, pos, value) -> writer.writeString((BinaryString)value);
                break;
            }
            case BOOLEAN: {
                fieldWriter = (writer, pos, value) -> writer.writeBoolean((Boolean)value);
                break;
            }
            case BINARY: 
            case VARBINARY: {
                fieldWriter = (writer, pos, value) -> writer.writeBinary((byte[])value);
                break;
            }
            case DECIMAL: {
                int decimalPrecision = DataTypeChecks.getPrecision(fieldType);
                fieldWriter = (writer, pos, value) -> writer.writeDecimal((Decimal)value, decimalPrecision);
                break;
            }
            case TINYINT: {
                fieldWriter = (writer, pos, value) -> writer.writeByte((Byte)value);
                break;
            }
            case SMALLINT: {
                fieldWriter = (writer, pos, value) -> writer.writeShort((Short)value);
                break;
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: {
                fieldWriter = (writer, pos, value) -> writer.writeInt((Integer)value);
                break;
            }
            case BIGINT: {
                fieldWriter = (writer, pos, value) -> writer.writeLong((Long)value);
                break;
            }
            case FLOAT: {
                fieldWriter = (writer, pos, value) -> writer.writeFloat(((Float)value).floatValue());
                break;
            }
            case DOUBLE: {
                fieldWriter = (writer, pos, value) -> writer.writeDouble((Double)value);
                break;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                int timestampPrecision = DataTypeChecks.getPrecision(fieldType);
                fieldWriter = (writer, pos, value) -> writer.writeTimestamp((Timestamp)value, timestampPrecision);
                break;
            }
            case ARRAY: {
                Serializer arraySerializer = InternalSerializers.create(fieldType);
                fieldWriter = (writer, pos, value) -> writer.writeArray((InternalArray)value, (InternalArraySerializer)arraySerializer);
                break;
            }
            case MULTISET: 
            case MAP: {
                Serializer mapSerializer = InternalSerializers.create(fieldType);
                fieldWriter = (writer, pos, value) -> writer.writeMap((InternalMap)value, (InternalMapSerializer)mapSerializer);
                break;
            }
            case ROW: {
                RowCompactedSerializer rowSerializer = new RowCompactedSerializer((RowType)fieldType);
                fieldWriter = (writer, pos, value) -> writer.writeRow((InternalRow)value, rowSerializer);
                break;
            }
            default: {
                String msg = String.format("type %s not support in %s", fieldType.getTypeRoot().toString(), RowCompactedSerializer.class.getName());
                throw new IllegalArgumentException(msg);
            }
        }
        if (!fieldType.isNullable()) {
            return fieldWriter;
        }
        return (writer, pos, value) -> {
            if (value == null) {
                writer.setNullAt(pos);
            } else {
                fieldWriter.writeField(writer, pos, value);
            }
        };
    }

    private static FieldReader createFieldReader(DataType fieldType) {
        FieldReader fieldReader;
        switch (fieldType.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                fieldReader = (reader, pos) -> reader.readString();
                break;
            }
            case BOOLEAN: {
                fieldReader = (reader, pos) -> reader.readBoolean();
                break;
            }
            case BINARY: 
            case VARBINARY: {
                fieldReader = (reader, pos) -> reader.readBinary();
                break;
            }
            case DECIMAL: {
                int decimalPrecision = DataTypeChecks.getPrecision(fieldType);
                int decimalScale = DataTypeChecks.getScale(fieldType);
                fieldReader = (reader, pos) -> reader.readDecimal(decimalPrecision, decimalScale);
                break;
            }
            case TINYINT: {
                fieldReader = (reader, pos) -> reader.readByte();
                break;
            }
            case SMALLINT: {
                fieldReader = (reader, pos) -> reader.readShort();
                break;
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: {
                fieldReader = (reader, pos) -> reader.readInt();
                break;
            }
            case BIGINT: {
                fieldReader = (reader, pos) -> reader.readLong();
                break;
            }
            case FLOAT: {
                fieldReader = (reader, pos) -> Float.valueOf(reader.readFloat());
                break;
            }
            case DOUBLE: {
                fieldReader = (reader, pos) -> reader.readDouble();
                break;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                int timestampPrecision = DataTypeChecks.getPrecision(fieldType);
                fieldReader = (reader, pos) -> reader.readTimestamp(timestampPrecision);
                break;
            }
            case ARRAY: {
                fieldReader = (reader, pos) -> reader.readArray();
                break;
            }
            case MULTISET: 
            case MAP: {
                fieldReader = (reader, pos) -> reader.readMap();
                break;
            }
            case ROW: {
                RowCompactedSerializer serializer = new RowCompactedSerializer((RowType)fieldType);
                fieldReader = (reader, pos) -> reader.readRow(serializer);
                break;
            }
            default: {
                String msg = String.format("type %s not support in %s", fieldType.getTypeRoot().toString(), RowCompactedSerializer.class.getName());
                throw new IllegalArgumentException(msg);
            }
        }
        if (!fieldType.isNullable()) {
            return fieldReader;
        }
        return (reader, pos) -> {
            if (reader.isNullAt(pos)) {
                return null;
            }
            return fieldReader.readField(reader, pos);
        };
    }

    private static class SliceComparator
    implements Comparator<MemorySlice> {
        private final RowReader reader1;
        private final RowReader reader2;
        private final FieldReader[] fieldReaders;

        public SliceComparator(RowType rowType) {
            int bitSetInBytes = RowCompactedSerializer.calculateBitSetInBytes(rowType.getFieldCount());
            this.reader1 = new RowReader(bitSetInBytes);
            this.reader2 = new RowReader(bitSetInBytes);
            this.fieldReaders = new FieldReader[rowType.getFieldCount()];
            for (int i = 0; i < rowType.getFieldCount(); ++i) {
                this.fieldReaders[i] = RowCompactedSerializer.createFieldReader(rowType.getTypeAt(i));
            }
        }

        @Override
        public int compare(MemorySlice slice1, MemorySlice slice2) {
            this.reader1.pointTo(slice1.segment(), slice1.offset());
            this.reader2.pointTo(slice2.segment(), slice2.offset());
            for (int i = 0; i < this.fieldReaders.length; ++i) {
                Object o2;
                boolean isNull1 = this.reader1.isNullAt(i);
                boolean isNull2 = this.reader2.isNullAt(i);
                if (isNull1 && isNull2) continue;
                if (isNull1) {
                    return -1;
                }
                if (isNull2) {
                    return 1;
                }
                FieldReader fieldReader = this.fieldReaders[i];
                Object o1 = fieldReader.readField(this.reader1, i);
                int comp = ((Comparable)o1).compareTo(o2 = fieldReader.readField(this.reader2, i));
                if (comp == 0) continue;
                return comp;
            }
            return 0;
        }
    }

    private static class RowReader {
        private final int headerSizeInBytes;
        private MemorySegment segment;
        private MemorySegment[] segments;
        private int offset;
        private int position;

        private RowReader(int headerSizeInBytes) {
            this.headerSizeInBytes = headerSizeInBytes;
        }

        private void pointTo(byte[] bytes) {
            this.pointTo(MemorySegment.wrap(bytes), 0);
        }

        private void pointTo(MemorySegment segment, int offset) {
            this.segment = segment;
            this.segments = new MemorySegment[]{segment};
            this.offset = offset;
            this.position = offset + this.headerSizeInBytes;
        }

        private RowKind readRowKind() {
            return RowKind.fromByteValue(this.segment.get(this.offset));
        }

        private boolean isNullAt(int pos) {
            return MemorySegmentUtils.bitGet(this.segment, this.offset, pos + 8);
        }

        private boolean readBoolean() {
            return this.segment.getBoolean(this.position++);
        }

        private byte readByte() {
            return this.segment.get(this.position++);
        }

        private short readShort() {
            short value = this.segment.getShort(this.position);
            this.position += 2;
            return value;
        }

        private int readInt() {
            int value = this.segment.getInt(this.position);
            this.position += 4;
            return value;
        }

        private long readLong() {
            long value = this.segment.getLong(this.position);
            this.position += 8;
            return value;
        }

        private float readFloat() {
            float value = this.segment.getFloat(this.position);
            this.position += 4;
            return value;
        }

        private double readDouble() {
            double value = this.segment.getDouble(this.position);
            this.position += 8;
            return value;
        }

        private BinaryString readString() {
            int length = this.readUnsignedInt();
            BinaryString string = BinaryString.fromAddress(this.segments, this.position, length);
            this.position += length;
            return string;
        }

        private int readUnsignedInt() {
            int result = 0;
            for (int offset = 0; offset < 32; offset += 7) {
                byte b = this.readByte();
                result |= (b & 0x7F) << offset;
                if ((b & 0x80) != 0) continue;
                return result;
            }
            throw new Error("Malformed integer.");
        }

        private Decimal readDecimal(int precision, int scale) {
            return Decimal.isCompact(precision) ? Decimal.fromUnscaledLong(this.readLong(), precision, scale) : Decimal.fromUnscaledBytes(this.readBinary(), precision, scale);
        }

        private Timestamp readTimestamp(int precision) {
            if (Timestamp.isCompact(precision)) {
                return Timestamp.fromEpochMillis(this.readLong());
            }
            long milliseconds = this.readLong();
            int nanosOfMillisecond = this.readUnsignedInt();
            return Timestamp.fromEpochMillis(milliseconds, nanosOfMillisecond);
        }

        private byte[] readBinary() {
            int length = this.readUnsignedInt();
            byte[] bytes = new byte[length];
            this.segment.get(this.position, bytes, 0, length);
            this.position += length;
            return bytes;
        }

        private InternalArray readArray() {
            BinaryArray value = new BinaryArray();
            int length = this.readUnsignedInt();
            value.pointTo(this.segments, this.position, length);
            this.position += length;
            return value;
        }

        private InternalMap readMap() {
            BinaryMap value = new BinaryMap();
            int length = this.readUnsignedInt();
            value.pointTo(this.segments, this.position, length);
            this.position += length;
            return value;
        }

        private InternalRow readRow(RowCompactedSerializer serializer) {
            byte[] bytes = this.readBinary();
            return serializer.deserialize(bytes);
        }
    }

    private static class RowWriter {
        private final int headerSizeInBytes;
        private byte[] buffer;
        private MemorySegment segment;
        private int position;

        private RowWriter(int headerSizeInBytes) {
            this.headerSizeInBytes = headerSizeInBytes;
            this.setBuffer(new byte[Math.max(64, headerSizeInBytes)]);
            this.position = headerSizeInBytes;
        }

        private void reset() {
            this.position = this.headerSizeInBytes;
            for (int i = 0; i < this.headerSizeInBytes; ++i) {
                this.buffer[i] = 0;
            }
        }

        private void writeRowKind(RowKind kind) {
            this.buffer[0] = kind.toByteValue();
        }

        private void setNullAt(int pos) {
            MemorySegmentUtils.bitSet(this.segment, 0, pos + 8);
        }

        private void writeBoolean(boolean value) {
            this.ensureCapacity(1);
            this.segment.putBoolean(this.position++, value);
        }

        private void writeByte(byte value) {
            this.ensureCapacity(1);
            this.segment.put(this.position++, value);
        }

        private void writeShort(short value) {
            this.ensureCapacity(2);
            this.segment.putShort(this.position, value);
            this.position += 2;
        }

        private void writeInt(int value) {
            this.ensureCapacity(4);
            this.segment.putInt(this.position, value);
            this.position += 4;
        }

        private void writeLong(long value) {
            this.ensureCapacity(8);
            this.segment.putLong(this.position, value);
            this.position += 8;
        }

        private void writeFloat(float value) {
            this.ensureCapacity(4);
            this.segment.putFloat(this.position, value);
            this.position += 4;
        }

        private void writeDouble(double value) {
            this.ensureCapacity(8);
            this.segment.putDouble(this.position, value);
            this.position += 8;
        }

        private void writeString(BinaryString value) {
            this.writeSegments(value.getSegments(), value.getOffset(), value.getSizeInBytes());
        }

        private void writeDecimal(Decimal value, int precision) {
            if (Decimal.isCompact(precision)) {
                this.writeLong(value.toUnscaledLong());
            } else {
                this.writeBinary(value.toUnscaledBytes());
            }
        }

        private void writeTimestamp(Timestamp value, int precision) {
            if (Timestamp.isCompact(precision)) {
                this.writeLong(value.getMillisecond());
            } else {
                this.writeLong(value.getMillisecond());
                this.writeUnsignedInt(value.getNanoOfMillisecond());
            }
        }

        private void writeUnsignedInt(int value) {
            Preconditions.checkArgument(value >= 0);
            this.ensureCapacity(5);
            int len = VarLengthIntUtils.encodeInt(this.buffer, this.position, value);
            this.position += len;
        }

        private void writeArray(InternalArray value, InternalArraySerializer serializer) {
            BinaryArray binary = serializer.toBinaryArray(value);
            this.writeSegments(binary.getSegments(), binary.getOffset(), binary.getSizeInBytes());
        }

        private void writeMap(InternalMap value, InternalMapSerializer serializer) {
            BinaryMap binary = serializer.toBinaryMap(value);
            this.writeSegments(binary.getSegments(), binary.getOffset(), binary.getSizeInBytes());
        }

        private void writeRow(InternalRow value, RowCompactedSerializer serializer) {
            this.writeBinary(serializer.serializeToBytes(value));
        }

        private byte[] copyBuffer() {
            return Arrays.copyOf(this.buffer, this.position);
        }

        private void setBuffer(byte[] buffer) {
            this.buffer = buffer;
            this.segment = MemorySegment.wrap(buffer);
        }

        private void ensureCapacity(int size) {
            if (this.buffer.length - this.position < size) {
                this.grow(size);
            }
        }

        private void grow(int minCapacityAdd) {
            int newLen = Math.max(this.buffer.length * 2, this.buffer.length + minCapacityAdd);
            this.setBuffer(Arrays.copyOf(this.buffer, newLen));
        }

        private void writeBinary(byte[] value) {
            this.writeUnsignedInt(value.length);
            this.ensureCapacity(value.length);
            System.arraycopy(value, 0, this.buffer, this.position, value.length);
            this.position += value.length;
        }

        private void write(MemorySegment segment, int off, int len) {
            this.ensureCapacity(len);
            segment.get(off, this.buffer, this.position, len);
            this.position += len;
        }

        private void writeSegments(MemorySegment[] segments, int off, int len) {
            this.writeUnsignedInt(len);
            if (len + off <= segments[0].size()) {
                this.write(segments[0], off, len);
            } else {
                this.write(segments, off, len);
            }
        }

        private void write(MemorySegment[] segments, int off, int len) {
            this.ensureCapacity(len);
            int toWrite = len;
            int fromOffset = off;
            int toOffset = this.position;
            for (MemorySegment sourceSegment : segments) {
                int remain = sourceSegment.size() - fromOffset;
                if (remain > 0) {
                    int localToWrite = Math.min(remain, toWrite);
                    sourceSegment.get(fromOffset, this.buffer, toOffset, localToWrite);
                    toWrite -= localToWrite;
                    toOffset += localToWrite;
                    fromOffset = 0;
                    continue;
                }
                fromOffset -= sourceSegment.size();
            }
            this.position += len;
        }
    }

    private static interface FieldReader
    extends Serializable {
        public Object readField(RowReader var1, int var2);
    }

    private static interface FieldWriter
    extends Serializable {
        public void writeField(RowWriter var1, int var2, Object var3);
    }
}

