/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fs;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.IOUtils;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.fs.FileIOLoader;
import org.apache.paimon.fs.FileIOUtils;
import org.apache.paimon.fs.FileStatus;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.fs.RemoteIterator;
import org.apache.paimon.fs.ResolvingFileIO;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.fs.UnsupportedSchemeException;
import org.apache.paimon.fs.hadoop.HadoopFileIOLoader;
import org.apache.paimon.fs.local.LocalFileIO;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Public
@ThreadSafe
public interface FileIO
extends Serializable,
Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(FileIO.class);

    public boolean isObjectStore();

    public void configure(CatalogContext var1);

    public SeekableInputStream newInputStream(Path var1) throws IOException;

    public PositionOutputStream newOutputStream(Path var1, boolean var2) throws IOException;

    public FileStatus getFileStatus(Path var1) throws IOException;

    public FileStatus[] listStatus(Path var1) throws IOException;

    default public FileStatus[] listFiles(Path path, boolean recursive) throws IOException {
        ArrayList<FileStatus> files = new ArrayList<FileStatus>();
        try (RemoteIterator<FileStatus> iter = this.listFilesIterative(path, recursive);){
            while (iter.hasNext()) {
                files.add(iter.next());
            }
        }
        return files.toArray(new FileStatus[0]);
    }

    default public RemoteIterator<FileStatus> listFilesIterative(Path path, final boolean recursive) throws IOException {
        final LinkedList files = new LinkedList();
        final LinkedList<Path> directories = new LinkedList<Path>(Collections.singletonList(path));
        return new RemoteIterator<FileStatus>(){

            @Override
            public boolean hasNext() throws IOException {
                this.maybeUnpackDirectory();
                return !files.isEmpty();
            }

            @Override
            public FileStatus next() throws IOException {
                this.maybeUnpackDirectory();
                return (FileStatus)files.remove();
            }

            private void maybeUnpackDirectory() throws IOException {
                while (files.isEmpty() && !directories.isEmpty()) {
                    FileStatus[] statuses;
                    for (FileStatus f : statuses = FileIO.this.listStatus((Path)directories.remove())) {
                        if (!f.isDir()) {
                            files.add(f);
                            continue;
                        }
                        if (!recursive) continue;
                        directories.add(f.getPath());
                    }
                }
            }

            @Override
            public void close() {
            }
        };
    }

    default public FileStatus[] listDirectories(Path path) throws IOException {
        FileStatus[] statuses = this.listStatus(path);
        if (statuses != null) {
            statuses = (FileStatus[])Arrays.stream(statuses).filter(FileStatus::isDir).toArray(FileStatus[]::new);
        }
        return statuses;
    }

    public boolean exists(Path var1) throws IOException;

    public boolean delete(Path var1, boolean var2) throws IOException;

    public boolean mkdirs(Path var1) throws IOException;

    public boolean rename(Path var1, Path var2) throws IOException;

    @Override
    default public void close() throws IOException {
    }

    default public void deleteQuietly(Path file) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ready to delete " + file.toString());
        }
        try {
            if (!this.delete(file, false) && this.exists(file)) {
                LOG.warn("Failed to delete file " + file);
            }
        }
        catch (IOException e) {
            LOG.warn("Exception occurs when deleting file " + file, (Throwable)e);
        }
    }

    default public void deleteFilesQuietly(List<Path> files) {
        for (Path file : files) {
            this.deleteQuietly(file);
        }
    }

    default public void deleteDirectoryQuietly(Path directory) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ready to delete " + directory.toString());
        }
        try {
            if (!this.delete(directory, true) && this.exists(directory)) {
                LOG.warn("Failed to delete directory " + directory);
            }
        }
        catch (IOException e) {
            LOG.warn("Exception occurs when deleting directory " + directory, (Throwable)e);
        }
    }

    default public long getFileSize(Path path) throws IOException {
        return this.getFileStatus(path).getLen();
    }

    default public boolean isDir(Path path) throws IOException {
        return this.getFileStatus(path).isDir();
    }

    default public void checkOrMkdirs(Path path) throws IOException {
        if (this.exists(path)) {
            Preconditions.checkArgument(this.isDir(path), "The path '%s' should be a directory.", path);
        } else {
            this.mkdirs(path);
        }
    }

    default public String readFileUtf8(Path path) throws IOException {
        try (SeekableInputStream in = this.newInputStream(path);){
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8));
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            String string = builder.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean tryToWriteAtomic(Path path, String content) throws IOException {
        Path tmp = path.createTempPath();
        boolean success = false;
        try {
            this.writeFile(tmp, content, false);
            success = this.rename(tmp, path);
        }
        finally {
            if (!success) {
                this.deleteQuietly(tmp);
            }
        }
        return success;
    }

    default public void writeFile(Path path, String content, boolean overwrite) throws IOException {
        try (PositionOutputStream out = this.newOutputStream(path, overwrite);){
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
            writer.write(content);
            writer.flush();
        }
    }

    default public void overwriteFileUtf8(Path path, String content) throws IOException {
        try (PositionOutputStream out = this.newOutputStream(path, true);){
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
            writer.write(content);
            writer.flush();
        }
    }

    default public void overwriteHintFile(Path path, String content) throws IOException {
        this.overwriteFileUtf8(path, content);
    }

    default public void copyFile(Path sourcePath, Path targetPath, boolean overwrite) throws IOException {
        try (SeekableInputStream is = this.newInputStream(sourcePath);
             PositionOutputStream os = this.newOutputStream(targetPath, overwrite);){
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
    }

    default public void copyFiles(Path sourceDirectory, Path targetDirectory, boolean overwrite) throws IOException {
        FileStatus[] fileStatuses = this.listStatus(sourceDirectory);
        List copyFiles = Arrays.stream(fileStatuses).map(FileStatus::getPath).collect(Collectors.toList());
        for (Path file : copyFiles) {
            String fileName = file.getName();
            Path targetPath = new Path(targetDirectory.toString() + "/" + fileName);
            this.copyFile(file, targetPath, overwrite);
        }
    }

    default public Optional<String> readOverwrittenFileUtf8(Path path) throws IOException {
        int retryNumber = 0;
        Exception exception = null;
        while (retryNumber++ < 5) {
            try {
                return Optional.of(this.readFileUtf8(path));
            }
            catch (FileNotFoundException e) {
                return Optional.empty();
            }
            catch (Exception e) {
                if (!this.exists(path)) {
                    return Optional.empty();
                }
                if (e.getClass().getName().endsWith("org.apache.hadoop.fs.s3a.RemoteFileChangedException")) {
                    exception = e;
                    continue;
                }
                if (e.getMessage() != null && e.getMessage().contains("Blocklist for") && e.getMessage().contains("has changed")) {
                    exception = e;
                    continue;
                }
                throw e;
            }
        }
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        throw new RuntimeException(exception);
    }

    public static FileIO get(Path path, CatalogContext config) throws IOException {
        if (config.options().get(CatalogOptions.RESOLVING_FILE_IO_ENABLED).booleanValue()) {
            ResolvingFileIO fileIO = new ResolvingFileIO();
            fileIO.configure(config);
            return fileIO;
        }
        URI uri = path.toUri();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting FileIO by scheme {}.", (Object)uri.getScheme());
        }
        if (uri.getScheme() == null) {
            return new LocalFileIO();
        }
        if (uri.getScheme().equals("file") && uri.getAuthority() != null && !uri.getAuthority().isEmpty()) {
            String supposedUri = "file:///" + uri.getAuthority() + uri.getPath();
            throw new IOException("Found local file path with authority '" + uri.getAuthority() + "' in path '" + uri + "'. Hint: Did you forget a slash? (correct path would be '" + supposedUri + "')");
        }
        FileIOLoader loader = null;
        ArrayList<IOException> ioExceptionList = new ArrayList<IOException>();
        FileIOLoader preferIOLoader = config.preferIO();
        try {
            loader = FileIOUtils.checkAccess(preferIOLoader, path, config);
            if (loader != null && LOG.isDebugEnabled()) {
                LOG.debug("Found preferIOLoader {} with scheme {}.", (Object)loader.getClass().getName(), (Object)loader.getScheme());
            }
        }
        catch (IOException ioException) {
            ioExceptionList.add(ioException);
        }
        if (loader == null) {
            Map<String, FileIOLoader> loaders = FileIO.discoverLoaders();
            loader = loaders.get(uri.getScheme());
            if (!loaders.isEmpty() && LOG.isDebugEnabled()) {
                LOG.debug("Discovered FileIOLoaders: {}.", (Object)loaders.entrySet().stream().map(e -> String.format("{%s,%s}", e.getKey(), ((FileIOLoader)e.getValue()).getClass().getName())).collect(Collectors.joining(",")));
            }
        }
        FileIOLoader fallbackIO = config.fallbackIO();
        if (loader != null) {
            Set options = config.options().keySet().stream().map(String::toLowerCase).collect(Collectors.toSet());
            HashSet<String> missOptions = new HashSet<String>();
            for (String[] keys : loader.requiredOptions()) {
                boolean found = false;
                for (String key : keys) {
                    if (!options.contains(key.toLowerCase())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                missOptions.add(keys[0]);
            }
            if (missOptions.size() > 0) {
                IOException exception = new IOException(String.format("One or more required options are missing.\n\nMissing required options are:\n\n%s", String.join((CharSequence)"\n", missOptions)));
                ioExceptionList.add(exception);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Got {} but miss options. Will try to get fallback IO and Hadoop IO respectively.", (Object)loader.getClass().getName());
                }
                loader = null;
            }
        }
        if (loader == null) {
            try {
                loader = FileIOUtils.checkAccess(fallbackIO, path, config);
                if (loader != null && LOG.isDebugEnabled()) {
                    LOG.debug("Got fallback FileIOLoader: {}.", (Object)loader.getClass().getName());
                }
            }
            catch (IOException ioException) {
                ioExceptionList.add(ioException);
            }
        }
        if (loader == null) {
            try {
                loader = FileIOUtils.checkAccess(new HadoopFileIOLoader(), path, config);
                if (loader != null && LOG.isDebugEnabled()) {
                    LOG.debug("Got hadoop FileIOLoader: {}.", (Object)loader.getClass().getName());
                }
            }
            catch (IOException ioException) {
                ioExceptionList.add(ioException);
            }
        }
        if (loader == null) {
            String fallbackMsg = "";
            String preferMsg = "";
            if (preferIOLoader != null) {
                preferMsg = " " + preferIOLoader.getClass().getSimpleName() + " also cannot access this path.";
            }
            if (fallbackIO != null) {
                fallbackMsg = " " + fallbackIO.getClass().getSimpleName() + " also cannot access this path.";
            }
            UnsupportedSchemeException ex = new UnsupportedSchemeException(String.format("Could not find a file io implementation for scheme '%s' in the classpath.%s %s Hadoop FileSystem also cannot access this path '%s'.", uri.getScheme(), preferMsg, fallbackMsg, path));
            for (IOException ioException : ioExceptionList) {
                ex.addSuppressed(ioException);
            }
            throw ex;
        }
        FileIO fileIO = loader.load(path);
        fileIO.configure(config);
        return fileIO;
    }

    public static Map<String, FileIOLoader> discoverLoaders() {
        HashMap<String, FileIOLoader> results = new HashMap<String, FileIOLoader>();
        Iterator<FileIOLoader> iterator = ServiceLoader.load(FileIOLoader.class, FileIOLoader.class.getClassLoader()).iterator();
        iterator.forEachRemaining(fileIO -> {
            FileIOLoader previous = results.put(fileIO.getScheme(), (FileIOLoader)fileIO);
            if (previous != null) {
                throw new RuntimeException(String.format("Multiple FileIO for scheme '%s' found in the classpath.\nAmbiguous FileIO classes are:\n%s\n%s", fileIO.getScheme(), previous.getClass().getName(), fileIO.getClass().getName()));
            }
        });
        return results;
    }
}

