/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.utils.BitSet;
import org.apache.paimon.utils.Preconditions;

public class BloomFilter {
    private final BitSet bitSet;
    private final int numHashFunctions;

    public BloomFilter(long expectedEntries, int byteSize) {
        Preconditions.checkArgument((expectedEntries > 0L ? 1 : 0) != 0, (Object)"expectedEntries should be > 0");
        this.numHashFunctions = BloomFilter.optimalNumOfHashFunctions(expectedEntries, (long)byteSize << 3);
        this.bitSet = new BitSet(byteSize);
    }

    @VisibleForTesting
    int numHashFunctions() {
        return this.numHashFunctions;
    }

    public void setMemorySegment(MemorySegment memorySegment, int offset) {
        this.bitSet.setMemorySegment(memorySegment, offset);
    }

    public void unsetMemorySegment() {
        this.bitSet.unsetMemorySegment();
    }

    public MemorySegment getMemorySegment() {
        return this.bitSet.getMemorySegment();
    }

    public static int optimalNumOfBits(long inputEntries, double fpp) {
        return (int)((double)(-inputEntries) * Math.log(fpp) / (Math.log(2.0) * Math.log(2.0)));
    }

    static int optimalNumOfHashFunctions(long expectEntries, long bitSize) {
        return Math.max(1, (int)Math.round((double)bitSize / (double)expectEntries * Math.log(2.0)));
    }

    public void addHash(int hash1) {
        int hash2 = hash1 >>> 16;
        for (int i = 1; i <= this.numHashFunctions; ++i) {
            int combinedHash = hash1 + i * hash2;
            if (combinedHash < 0) {
                combinedHash ^= 0xFFFFFFFF;
            }
            int pos = combinedHash % this.bitSet.bitSize();
            this.bitSet.set(pos);
        }
    }

    public boolean testHash(int hash1) {
        int hash2 = hash1 >>> 16;
        for (int i = 1; i <= this.numHashFunctions; ++i) {
            int pos;
            int combinedHash = hash1 + i * hash2;
            if (combinedHash < 0) {
                combinedHash ^= 0xFFFFFFFF;
            }
            if (this.bitSet.get(pos = combinedHash % this.bitSet.bitSize())) continue;
            return false;
        }
        return true;
    }

    public void reset() {
        this.bitSet.clear();
    }

    public String toString() {
        return "BloomFilter:\n\thash function number:" + this.numHashFunctions + "\n" + this.bitSet;
    }

    public static Builder builder(long expectedRow, double fpp) {
        int numBytes = (int)Math.ceil((double)BloomFilter.optimalNumOfBits(expectedRow, fpp) / 8.0);
        Preconditions.checkArgument((numBytes > 0 ? 1 : 0) != 0, (String)"The optimal bits should > 0. expectedRow: %s, fpp: %s", (Object[])new Object[]{expectedRow, fpp});
        return new Builder(MemorySegment.wrap(new byte[numBytes]), expectedRow);
    }

    public static class Builder {
        private final MemorySegment buffer;
        private final BloomFilter filter;
        private final long expectedEntries;

        Builder(MemorySegment buffer, long expectedEntries) {
            this.buffer = buffer;
            this.filter = new BloomFilter(expectedEntries, buffer.size());
            this.filter.setMemorySegment(buffer, 0);
            this.expectedEntries = expectedEntries;
        }

        public boolean testHash(int hash) {
            return this.filter.testHash(hash);
        }

        public void addHash(int hash) {
            this.filter.addHash(hash);
        }

        public MemorySegment getBuffer() {
            return this.buffer;
        }

        public long expectedEntries() {
            return this.expectedEntries;
        }

        @VisibleForTesting
        public BloomFilter getFilter() {
            return this.filter;
        }
    }
}

